import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';

const TEST_SELECTOR = 'tab-container';
const TAB_CONTAINER_SELECTOR = '[data-test-selector="tab-container"]';

moduleForComponent('common/tab-container', 'Integration | Component | common/tab-container', {
  beforeEach() {
    this.set('isFullWidth', false);
    this.set('isRightAligned', false);
    this.set('testSelector', TEST_SELECTOR);

    this.template = hbs`
      {{#common/tab-container
        isFullWidth=isFullWidth
        isRightAligned=isRightAligned
        testSelector=testSelector
      }}
        <div data-test-selector='nested'></div>
      {{/common/tab-container}}
    `;
    this.render(this.template);
  }
});

test('rendering the tab container', function(assert) {
  assert.elementCount(TAB_CONTAINER_SELECTOR, 1, 'container should be present');
  assert.elementCount('[data-test-selector="nested"]', 1, 'should render nested content');
  assert.notElementHasClass(TAB_CONTAINER_SELECTOR, 'tabs--right', 'should add proper CSS class');
  assert.notElementHasClass(TAB_CONTAINER_SELECTOR, 'tabs--fullwidth', 'should add proper CSS class');
});

test('right-aligned', function(assert) {
  this.set('isFullWidth', true);
  this.set('isRightAligned', true);

  assert.elementHasClass(TAB_CONTAINER_SELECTOR, 'tabs--right', 'should add proper CSS class');
  assert.elementHasClass(TAB_CONTAINER_SELECTOR, 'tabs--fullwidth', 'should add proper CSS class');
});
