import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';

const TEST_SELECTOR = 'tab-item';
const TAB_CONTAINER_SELECTOR = '[data-test-selector="tab-item"]';

moduleForComponent('common/tab-item', 'Integration | Component | common/tab-item', {
  beforeEach() {
    this.set('isActive', false);
    this.set('testSelector', TEST_SELECTOR);

    this.template = hbs`
      {{#common/tab-item
        isActive=isActive
        testSelector=testSelector
      }}
        <div data-test-selector='nested'></div>
      {{/common/tab-item}}
    `;
    this.render(this.template);
  }
});

test('rendering the tab container', function(assert) {
  assert.elementCount(TAB_CONTAINER_SELECTOR, 1, 'container should be present');
  assert.elementCount('[data-test-selector="nested"]', 1, 'should render nested content');
  assert.notElementHasClass(TAB_CONTAINER_SELECTOR, 'tw-tabs__item--active', 'should add proper CSS class');
});

test('right-aligned', function(assert) {
  this.set('isActive', true);

  assert.elementHasClass(TAB_CONTAINER_SELECTOR, 'tw-tabs__item--active', 'should add proper CSS class');
});
