import EmberObject from 'ember-object';
import hbs from 'htmlbars-inline-precompile';
import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';

const TAG_SELECTOR = '.js-community-preview';
const PROMOTED_TAG_SELECTOR = '.js-community-preview--is-promoted';

const FOOD_COMMUNITY = EmberObject.create({ name: 'food' });
const GAMEDEV_COMMUNITY = EmberObject.create({ name: 'gamedev' });
const GAMEART_COMMUNITY = EmberObject.create({ name: 'gameart' });

moduleForComponent('community-discovery', {
  beforeEach() {
    this.set('promotedCommunities', []);
    this.set('communities', [FOOD_COMMUNITY, GAMEDEV_COMMUNITY]);
  }
});

test('it displays each tag', function (assert) {
  assert.expect(1);
  this.render(hbs`{{community-discovery communities=communities promotedCommunities=promotedCommunities}}`);
  assert.equal(this.$(TAG_SELECTOR).length, 2);
});

test('it does not display current tag', function (assert) {
  assert.expect(1);
  this.set('currentTag', FOOD_COMMUNITY);
  this.render(hbs`{{community-discovery currentTag=currentTag communities=communities promotedCommunities=promotedCommunities}}`);
  assert.equal(this.$(TAG_SELECTOR).length, 1);
});

test('it displays promoted tags', function (assert) {
  assert.expect(2);
  GAMEART_COMMUNITY.set('isPromoted', true);
  this.set('promotedCommunities', [GAMEART_COMMUNITY]);
  this.render(hbs`{{community-discovery communities=communities promotedCommunities=promotedCommunities}}`);
  assert.equal(this.$(TAG_SELECTOR).length, 3);
  assert.equal(this.$(PROMOTED_TAG_SELECTOR).length, 1);
});

test('it does not show duplicate promoted tags', function (assert) {
  assert.expect(1);
  FOOD_COMMUNITY.set('isPromoted', true);
  this.set('communities', [FOOD_COMMUNITY]);
  this.set('promotedCommunities', [FOOD_COMMUNITY]);
  this.render(hbs`{{community-discovery communities=communities promotedCommunities=promotedCommunities}}`);
  assert.equal(this.$(TAG_SELECTOR).length, 1);
});


test('it does not show duplicate tags', function (assert) {
  assert.expect(1);
  FOOD_COMMUNITY.set('isPromoted', true);
  this.set('communities', [FOOD_COMMUNITY]);
  this.set('promotedCommunities', [FOOD_COMMUNITY]);
  this.render(hbs`{{community-discovery communities=communities promotedCommunities=promotedCommunities}}`);
  assert.equal(this.$(TAG_SELECTOR).length, 1);
});
