import Component from 'ember-component';
import EmberObject from 'ember-object';
import hbs from 'htmlbars-inline-precompile';
import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';

const COMMUNITY_SELECTOR = '.community';

const FOOD_COMMUNITY = EmberObject.create({ name: 'food', isCommunity: true });
const GAMEDEV_COMMUNITY = EmberObject.create({ name: 'gamedev', isCommunity: true });
const GAMEART_COMMUNITY = EmberObject.create({ name: 'gameart', isCommunity: true });

moduleForComponent('community-list', {
  beforeEach() {
    this.owner.register('component:infinite-scroll', Component.extend());
    this.owner.register('template:component/infinite-scroll', hbs`{{yield}}`);
    this.set('communities', [FOOD_COMMUNITY, GAMEDEV_COMMUNITY, GAMEART_COMMUNITY]);
  }
});

test('it passes all communities to child content', function (assert) {
  assert.expect(1);
  this.render(hbs`{{#community-list communities=communities}}<span class="community"></span>{{/community-list}}`);
  assert.equal(this.$(COMMUNITY_SELECTOR).length, 3);
});
