import hbs from 'htmlbars-inline-precompile';
import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';

moduleForComponent('community-preview', {
  beforeEach() {
    this.set('fakeCommunity', {
      id: 'food',
      name: 'food',
      channels: 12,
      viewers: 4012,
      banner: '/path/to/url',
      isCommunity: false
    });
  }
});

test('displays viewer count', function (assert) {
  this.render(hbs`{{community-preview community=fakeCommunity}}`);
  let streamText = this.$('.js-community-viewers').text().trim();
  assert.equal(streamText, this.get('fakeCommunity.viewers').toString());
});

test('displays stream count', function (assert) {
  this.render(hbs`{{community-preview community=fakeCommunity}}`);
  let viewersText = this.$('.js-community-streams').text().trim();
  assert.equal(viewersText, this.get('fakeCommunity.channels').toString());
});
