import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import Ember from 'ember';

const {run} = Ember;

const UNKNOWN_NAME = 'John Doe';

moduleForComponent('component-outlet', {
  beforeEach() {
    this.inject.service('component-outlet', {as: 'componentOutletService'});
    this.owner.register(
      'template:components/test-nav',
      hbs`{{if model model.name 'John Doe'}}`
    );
  }
});

test('renders into component outlets', function (assert) {
  let service = this.get('componentOutletService');

  this.render(hbs`{{component-outlet 'sidebar' sourceTemplateName='barry'}}`);

  assert.equal(this.$().text().trim(), '', 'precond');

  run(() => {
    service.render('test-nav', {outlet: 'sidebar', sourceTemplateName: 'barry'});
  });

  assert.equal(this.$().text().trim(), UNKNOWN_NAME);
});

test('renders into component outlets with model', function (assert) {
  let service = this.get('componentOutletService');
  let model = {name: 'Dr. John'};

  this.render(hbs`{{component-outlet 'sidebar' sourceTemplateName='barry'}}`);

  assert.equal(this.$().text().trim(), '', 'precond');

  run(() => {
    service.render('test-nav', {
      outlet: 'sidebar',
      sourceTemplateName: 'barry',
      model
    });
  });

  assert.equal(this.$().text().trim(), model.name);
});

test('disconnect component outlets', function (assert) {
  let service = this.get('componentOutletService');
  service.render('test-nav', {outlet: 'sidebar', sourceTemplateName: 'steve'});

  this.render(hbs`{{component-outlet 'sidebar' sourceTemplateName='steve'}}`);
  assert.equal(this.$().text().trim(), UNKNOWN_NAME, 'precond');

  run(() => {
    service.disconnect({sourceTemplateName: 'steve', outlet: 'sidebar'});
  });
  assert.equal(this.$().text().trim(), '');
});
