import EmberObject from 'ember-object';
import Service from 'ember-service';
import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';

const sessionStub = Service.extend({
  userData: {
    login: 'Extalix',
    id: 'extalix'
  }
});

moduleForComponent('twitch-conversations/conversation-line', 'Integration | Component | twitch-conversations/conversation-line', {
  beforeEach: function () {
    this.owner.register('service:session', sessionStub);
  }
});

let createMessageObject = function (text, options = {}) {
  return EmberObject.create({
    from: options.from,
    body: text
  });
};

test('renders the correct message', function (assert) {
  let message = createMessageObject('hi', {from: {displayName: 'Extalix'}});
  this.set('message', message);
  this.render(hbs`
    {{twitch-conversations/conversation-line message=message}}
  `);

  assert.equal(this.$('.conversation-chat-line .message').text().trim(), 'hi', 'The correct string is displayed');
});
