import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import moduleForComponent from 'web-client/tests/helpers/module-for-component';

moduleForComponent('copyable-item', 'Integration | Component | copyable item', {
  integration: true
});

test('includes copy button by default', function(assert) {
  this.render(hbs`{{copyable-item}}`);

  assert.elementText($('.copy-btn'), 'copy');
});

test('can be passed text to be copied', function(assert) {
  this.render(hbs`{{copyable-item text='abc123'}}`);

  assert.equal($('.copy-text')[0].value, 'abc123');
  assert.elementText($('.copy-btn'), 'copy');
});

test('changes the copy button if isCopied is triggered', function(assert) {
  this.render(hbs`{{copyable-item isCopied=true}}`);

  assert.elementText($('.copy-btn'), 'copied');
});
