import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import { pollTaskFor } from 'web-client/mixins/context-bound-tasks';
import wait from 'ember-test-helpers/wait';

moduleForComponent('countdown-timer', 'Integration | Component | countdown timer');

test('it renders with endDate argument', function(assert) {
  assert.expect(4);

  this.set('dateString', 'May 19, 2032');

  let times = [
    // Thu Sep 22 2016 23:59:59
    new Date(2016, 8, 22, 23, 59, 59),
    new Date(2016, 8, 23,  0,  0,  0),
    new Date(2016, 8, 23,  0,  0,  1)
  ];

  this.set('now', () => times.shift());

  this.render(hbs`{{countdown-timer now=now interval=1 endDate=dateString}}`);

  let readText = () => this.$().text().trim().replace(/\s+/mg, ' ');

  assert.equal(readText(), '5717 Days 0 Hours 0 Mins 1 Secs', 'initial countdown is correct');

  return wait().then(() => {
    // let the first pollTask run and wait for the UI to update
    pollTaskFor('countdown-timer');

    return wait();
  }).then(() => {
    assert.equal(readText(), '5717 Days 0 Hours 0 Mins 0 Secs', 'updated countdown is correct');
    pollTaskFor('countdown-timer');

    return wait();
  }).then(() => {
    assert.equal(readText(), '5716 Days 23 Hours 59 Mins 59 Secs', 'updated countdown is correct');

    assert.deepEqual(times, [], 'each time was used');
  });
});
