import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import { openDatepicker } from 'ember-pikaday/helpers/pikaday';
import moment from 'moment';

moduleForComponent('dashboards/events/time-range', 'Integration | Component | dashboards/events/time-range', {
  integration: true
});

test('it fires an onStartChange when date changes', function(assert) {
  assert.expect(2);

  let onStartChangeCalls = [];
  this.set('onStartChange', (date) => {
    onStartChangeCalls.push(date);
  });

  let now = new Date();
  let tomorrow = moment(now).add(1, 'day').toDate();
  this.set('now', now);

  this.render(hbs`
    {{#dashboards/events/time-range start=now onStartChange=onStartChange as |range|}}
      {{range.startDatePicker}}
    {{/dashboards/events/time-range}}
  `);

  openDatepicker(this.$('input')).selectDate(tomorrow);

  assert.equal(onStartChangeCalls.length, 1, 'called onStartChange once');

  let newDate = onStartChangeCalls[0];
  assert.ok(moment(tomorrow).isSame(newDate), 'called with correct date/time');
});

test('it fires an onStartChange when time changes', function(assert) {
  assert.expect(2);

  let onStartChangeCalls = [];
  this.set('onStartChange', (date) => {
    onStartChangeCalls.push(date);
  });

  let tomorrow = moment().add('1', 'day');
  let expectedNextTime = moment(tomorrow).set({ hour: 11, minute: 30, seconds: 0, milliseconds: 0 });
  this.set('tomorrow', tomorrow);

  this.render(hbs`
    {{#dashboards/events/time-range start=tomorrow onStartChange=onStartChange as |range|}}
      {{range.startTimePicker}}
    {{/dashboards/events/time-range}}
  `);

  let input = this.$('[data-test-time-picker-input]');
  input.val('11:30am');
  input.change();

  assert.equal(onStartChangeCalls.length, 1, 'called onStartChange once');

  let newTime = onStartChangeCalls[0];
  assert.ok(moment(expectedNextTime).isSame(newTime), 'called with correct date/time');
});

test('it fires an onEndChange when date changes', function(assert) {
  assert.expect(2);

  let onEndChangeCalls = [];
  this.set('onEndChange', (date) => {
    onEndChangeCalls.push(date);
  });

  let now = new Date();
  let tomorrow = moment(now).add(1, 'day').toDate();
  this.set('now', now);

  this.render(hbs`
    {{#dashboards/events/time-range end=now onEndChange=onEndChange as |range|}}
      {{range.endDatePicker}}
    {{/dashboards/events/time-range}}
  `);

  openDatepicker(this.$('input')).selectDate(tomorrow);

  assert.equal(onEndChangeCalls.length, 1, 'called onEndChange once');

  let newDate = onEndChangeCalls[0];
  assert.ok(moment(tomorrow).isSame(newDate), 'called with correct date/time');
});

test('it fires an onEndChange when time changes', function(assert) {
  assert.expect(2);

  let onEndChangeCalls = [];
  this.set('onEndChange', (date) => {
    onEndChangeCalls.push(date);
  });

  let tomorrow = moment().add('1', 'day');
  let expectedNextTime = moment(tomorrow).set({ hour: 23, minute: 0, seconds: 0, milliseconds: 0 });
  this.set('tomorrow', tomorrow);

  this.render(hbs`
    {{#dashboards/events/time-range end=tomorrow onEndChange=onEndChange as |range|}}
      {{range.endTimePicker}}
    {{/dashboards/events/time-range}}
  `);

  let input = this.$('[data-test-time-picker-input]');
  input.val('11:00pm');
  input.change();

  assert.equal(onEndChangeCalls.length, 1, 'called onEndChange once');

  let newTime = onEndChangeCalls[0];
  assert.ok(moment(expectedNextTime).isSame(newTime), 'called with correct date/time');
});

test('it rounds minutes to the nearest 30m mark', function(assert) {
  assert.expect(2);

  let onStartChangeCalls = [];
  this.set('onStartChange', (date) => {
    onStartChangeCalls.push(date);
  });

  let onEndChangeCalls = [];
  this.set('onEndChange', (date) => {
    onEndChangeCalls.push(date);
  });

  let tomorrow = moment().add('1', 'day');
  this.set('tomorrow', tomorrow);

  this.render(hbs`
    {{#dashboards/events/time-range
      start=tomorrow
      end=tomorrow
      onStartChange=onStartChange
      onEndChange=onEndChange as |range|}}
      {{range.startTimePicker}}
      {{range.endTimePicker}}
    {{/dashboards/events/time-range}}
  `);

  let startTimeInput = this.$('[data-test-time-picker-input]').eq(0);
  startTimeInput.val('11:10am');
  startTimeInput.change();

  let newStartTime = onStartChangeCalls[0];
  let expectedStartTime = moment(tomorrow).set({ hour: 11, minute: 0, seconds: 0, milliseconds: 0 });
  assert.datesMatch(newStartTime, expectedStartTime, 'the time is updated to reflect the adjusted time');

  let endTimeInput = this.$('[data-test-time-picker-input]').eq(1);
  endTimeInput.val('11:45am');
  endTimeInput.change();

  let newEndTime = onEndChangeCalls[0];
  let expectedEndTime = moment(tomorrow).set({ hour: 12, minute: 0, seconds: 0, milliseconds: 0 });
  assert.datesMatch(newEndTime, expectedEndTime, 'the time is updated to reflect the adjusted time');
});
