import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import run from 'ember-runloop';
import wait from 'ember-test-helpers/wait';

moduleForComponent('dashboards/live-widget', 'Integration | Component | dashboard/live-widget', {
  integration: true
});

test('it renders', function(assert) {
  assert.expect(1);

  // Template block usage:
  this.render(hbs`
    {{#dashboards/live-widget}}
      test component
    {{/dashboards/live-widget}}
  `);

  assert.elementText(this.$('.js-live-widget__body'), 'test component', 'live-widget body is correct');
});

test('Title can be set', function(assert) {
  assert.expect(1);

  this.set('componentTitle', 'Component Title');

  this.render(hbs`
    {{#dashboards/live-widget title=componentTitle}}
      test component
    {{/dashboards/live-widget}}
  `);

  assert.elementText(this.$('.dash-widget__header-title'), `${ this.get('componentTitle') }`, 'Component title matches');
});

test('Can collapse widget', function(assert){
  let done = assert.async();
  assert.expect(3);

  let foo = () => {
    assert.ok(true, 'saveConfig was called');
  };

  this.set('saveConfig', foo);
  this.set('componentTitle', 'Component Title');

  this.render(hbs`
    {{#dashboards/live-widget title=componentTitle saveConfig=(action saveConfig)}}
      test component
    {{/dashboards/live-widget}}
  `);

  assert.notOk(this.$('.js-live-widget').hasClass('dash-widget--collapsed'), "body is not collapsed");

  this.$('.button:first').click();

  return wait().then(() => {
    run.later(this, function () {
      assert.ok(this.$('.js-live-widget').hasClass('dash-widget--collapsed'), "body is collapsed");
      done();
    }, 400);
  });
});

test('With settings', function(assert){
  let done = assert.async();
  assert.expect(5);

  this.set('componentTitle', 'Component Title');

  this.render(hbs`
    {{#dashboards/live-widget title=componentTitle hasSettings=true as |widget|}}
      {{#if (eq widget 'widget-settings')}}
        test component settings
      {{else}}
        test component body
      {{/if}}
    {{/dashboards/live-widget}}
  `);

  assert.notOk(this.$('.js-live-widget').hasClass('dash-widget--collapsed'), "body is not collapsed");

  return wait().then(() => {
    assert.equal(this.$('[data-test-selector=settings-button]').length, 1, 'button appears');
    assert.equal(this.$('.balloon--dropmenu').hasClass('hide'), true, 'settings body hidden');
    this.$('[data-test-selector=settings-button]').click();
    return wait();
  }).then(() => {
    assert.equal(this.$('.balloon--dropmenu').hasClass('hide'), false, 'settings hidden');
    assert.elementText(this.$('.balloon--dropmenu'), 'test component settings', 'settings correct');
    done();
  });
});
