import Object from 'ember-object';
import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import wait from 'ember-test-helpers/wait';
import MockAutohostService from 'web-client/tests/helpers/mock-autohost-service';

moduleForComponent('dashboards/live/host-mode/host-list', 'Integration | Component | dashboards/live/host-mode/host-list', {
  beforeEach() {
    this.owner.register('service:autohost', MockAutohostService);
  }
});

test('renders empty message', function (assert) {
  assert.expect(2);

  this.set('hosts', []);
  this.set('emptyMessage', 'foobar');
  this.render(hbs`{{dashboards/live/host-mode/host-list hosts=hosts emptyMessage=emptyMessage}}`);

  return wait().then(() => {
    assert.equal(this.$('.card__layout').length, 0, 'no hosts');
    assert.elementText(this.$('[data-test-selector=host-list]'), 'foobar', 'empty message shows');
  });
});

test('renders hosts without button', function (assert) {
  assert.expect(5);

  let hosts = [{_id: 1, name: 'user1', displayName: 'USER1'}, {_id: 2, name: 'user2', displayName: 'User2'}];
  this.set('hosts', hosts.map((channel) => Object.create(channel)));
  this.render(hbs`{{dashboards/live/host-mode/host-list hosts=hosts}}`);

  return wait().then(() => {
    assert.equal(this.$('.card__layout').length, 2, 'renders hosts');
    assert.elementText(this.$('.card__layout')[0], 'USER1', 'renders first host');
    assert.elementText(this.$('.card__layout')[1], 'User2', 'renders second host');
    assert.equal(this.$('[data-test-selector=remove-button]').length, 0, 'no button');
    assert.equal(this.$('[data-test-selector=add-button]').length, 0, 'no button');
  });
});

test('renders button if owner', function (assert) {
  assert.expect(3);

  let hosts = [{_id: 1, name: 'user1', displayName: 'USER1'}];
  this.set('hosts', hosts.map((channel) => Object.create(channel)));
  this.render(hbs`{{dashboards/live/host-mode/host-list hosts=hosts isChannelOwner=true}}`);

  return wait().then(() => {
    assert.equal(this.$('.card__layout').length, 1, 'renders host');
    assert.equal(this.$('[data-test-selector=add-button]').length, 1, 'add button present');

    let autohost = this.owner.lookup('service:autohost');
    autohost.set('list', hosts);
    return wait();
  }).then(() => {
    assert.equal(this.$('[data-test-selector=remove-button]').length, 1, 'remove button present');
  });
});

test('show all and show fewer buttons', function (assert) {
  assert.expect(5);

  let hosts = [
    {_id: 1, name: 'user1', displayName: 'USER1'},
    {_id: 2, name: 'user2', displayName: 'USER1'},
    {_id: 3, name: 'user3', displayName: 'USER1'},
    {_id: 4, name: 'user4', displayName: 'USER1'},
    {_id: 5, name: 'user5', displayName: 'USER1'},
    {_id: 6, name: 'user6', displayName: 'USER1'}
  ];

  this.set('hosts', hosts.map((channel) => Object.create(channel)));
  this.set('testTrackDashboardEvent', () => {
    assert.ok(true, 'trackDashboardEvent is fired');
  });

  this.render(hbs`
    {{dashboards/live/host-mode/host-list
      hosts=hosts
      trackDashboardEvent=testTrackDashboardEvent
    }}
  `);

  return wait().then(() => {
    assert.equal(this.$('[data-test-selector=host-list]').hasClass('dash-widget__list--expanded'), false, 'not expanded');
    assert.elementText(this.$('[data-test-selector=toggle-showing-hosts]'), 'Show all (6)', 'shows show all text with right number');
    this.$('[data-test-selector=toggle-showing-hosts]').click();

    return wait();
  }).then(() => {
    assert.equal(this.$('[data-test-selector=host-list]').hasClass('dash-widget__list--expanded'), true, 'expanded');
    assert.elementText(this.$('[data-test-selector=toggle-showing-hosts]'), 'Show fewer', 'shows show fewer');
  });
});
