import Service from 'ember-service';
import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import wait from 'ember-test-helpers/wait';
import RSVP from 'rsvp';
import MockAutohostService from 'web-client/tests/helpers/mock-autohost-service';
import Object from 'ember-object';
import { pollTaskFor } from 'web-client/mixins/context-bound-tasks';

const TMI_STUB = Service.extend({
  tmiSession: RSVP.resolve({
    getRoom(userId) {
      if (userId === "foo" || userId === 'twitch') {
        return RSVP.resolve({
          hostTarget() {
            return RSVP.resolve({ host_target: 'baz'});
          },

          hosts() {
            return RSVP.resolve({ hosts: [] });
          }
        });
      }

      return RSVP.resolve({
        hostTarget() {
          return RSVP.resolve({ host_target: undefined });
        },

        hosts() {
          return RSVP.resolve({
            hosts: [
              { host: 'foo' },
              { host: 'baz' }
            ]
          });
        }
      });
    }
  })
});

moduleForComponent('dashboards/live/host-mode', 'Integration | Component | dashboards/live/host-mode', {
  beforeEach() {
    this.server.create('user', {
      id: 'foo',
      name: 'foo',
      display_name: 'FooBar',
      logo: 'logoPath'
    });

    this.server.create('user', {
      id: 'baz',
      name: 'baz',
      display_name: 'BazFoo',
      logo: 'BazFooLogoPath'
    });

    this.register('service:tmi', TMI_STUB);
    this.register('service:autohost', MockAutohostService);
  }
});

test("it displays who the current channel is hosting, and their details", function (assert) {
  assert.expect(2);

  let done = assert.async();

  this.set('channel', {id: 'foo'});
  this.render(hbs`{{dashboards/live/host-mode channel=channel}}`);

  return wait().then(() => {
    assert.elementText(this.$('.form__label'), 'You are hosting', 'title is Hosting when hosting a channel');
    assert.elementText(this.$('.card__title'), 'BazFoo', 'shows the name of the channel it is hosting');

    return done();
  });
});

test("it displays who is hosting the current channel", function (assert) {
  assert.expect(4);
  let done = assert.async();

  this.set('channel', {id: 'boo'});
  this.render(hbs`{{dashboards/live/host-mode channel=channel}}`);

  return wait().then(() => {
    assert.elementText(this.$('.dash-tabs__item')[0], 'Hosting you', 'title is Hosting you when hosted by one or more a channel');
    assert.elementText(this.$('.dash-tabs__item')[1], 'Auto hosts you', 'auto hosts tab is there');
    let displayNames = this.$('.js-host-details__display-name');
    assert.equal(displayNames.eq(0).text().trim(), 'FooBar', 'shows the name of the channel hosting the current foo');
    assert.equal(displayNames.eq(1).text().trim(), 'BazFoo', 'shows the name of the channel hosting the current baz');

    return done();
  });
});

test("it displays snoozed message", function (assert) {
  assert.expect(1);
  let done = assert.async();

  let autohost = this.owner.lookup('service:autohost');
  autohost.snooze();

  this.set('channel', {id: 'boo'});
  this.render(hbs`{{dashboards/live/host-mode channel=channel}}`);

  return wait().then(() => {
    assert.elementText(this.$('.dash-host-block h4'), 'Auto host is paused', 'snooze indicated');

    return done();
  });
});

test("it shows auto hosted by count", function (assert) {
  assert.expect(6);
  let done = assert.async();

  this.set('channel', {id: 'twitch'});
  this.render(hbs`{{dashboards/live/host-mode channel=channel isChannelOwner=true}}`);

  return wait().then(() => {
    let autohost = this.owner.lookup('service:autohost');
    autohost.set('newAutoHostedBy', [
      Object.create({ _id: 1 })
    ]);

    pollTaskFor('host-mode#monitor-hosts');
    return wait();
  }).then(() => {
    assert.elementText(this.$('[data-test-selector=unseen-channels-count]'), '1', 'shows 1 unseen');

    let autohost = this.owner.lookup('service:autohost');
    autohost.set('newAutoHostedBy', []);
    pollTaskFor('host-mode#monitor-hosts');
    return wait();
  }).then(() => {
    assert.elementText(this.$('[data-test-selector=unseen-channels-count]'), '1', 'still shows 1 unseen');

    let autohost = this.owner.lookup('service:autohost');
    autohost.set('newAutoHostedBy', [
      Object.create({ _id: 1 })
    ]);
    pollTaskFor('host-mode#monitor-hosts');
    return wait();
  }).then(() => {
    assert.elementText(this.$('[data-test-selector=unseen-channels-count]'), '1', 'same channel does not change indicator');

    this.$('[data-test-selector=auto-hosted-by-tab]').click();
    return wait();
  }).then(() => {
    assert.elementText(this.$('[data-test-selector=unseen-channels-count]'), '', 'unseen is cleared');

    let autohost = this.owner.lookup('service:autohost');
    autohost.set('newAutoHostedBy', [
      Object.create({ _id: 1 }),
      Object.create({ _id: 2 }),
      Object.create({ _id: 3 })
    ]);
    pollTaskFor('host-mode#monitor-hosts');
    return wait();
  }).then(() => {
    assert.elementText(this.$('[data-test-selector=unseen-channels-count]'), '', 'unseen does not update when tab is selected');

    this.$('[data-test-selector=hosted-by-tab]').click();

    let autohost = this.owner.lookup('service:autohost');
    autohost.set('newAutoHostedBy', [
      Object.create({ _id: 1 }),
      Object.create({ _id: 2 }),
      Object.create({ _id: 4 }),
      Object.create({ _id: 5 })
    ]);
    pollTaskFor('host-mode#monitor-hosts');
    return wait();
  }).then(() => {
    assert.elementText(this.$('[data-test-selector=unseen-channels-count]'), '2', 'unseen updates');

    return done();
  });
});
