import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import wait from 'ember-test-helpers/wait';
import MockAutohostService from 'web-client/tests/helpers/mock-autohost-service';

moduleForComponent('dashboards/live/host-mode/host-settings', 'Integration | Component | dashboards/live/host-mode/host-settings', {
  beforeEach() {
    this.owner.register('service:autohost', MockAutohostService);
  }
});

test("renders", function (assert) {
  assert.expect(1);

  this.render(hbs`{{dashboards/live/host-mode/host-settings isChannelOwner=true}}`);

  return wait().then(() => {
    assert.equal(this.$('[data-test-selector=snooze-button]').length, 1, 'shows snooze');
  });
});

test("shows unsnoozed", function (assert) {
  assert.expect(1);

  let autohost = this.owner.lookup('service:autohost');
  autohost.snooze();

  this.render(hbs`{{dashboards/live/host-mode/host-settings isChannelOwner=true}}`);

  return wait().then(() => {
    assert.equal(this.$('[data-test-selector=unsnooze-button]').length, 1, 'shows unsnooze');
  });
});
