import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import wait from 'ember-test-helpers/wait';
import Service from 'ember-service';
import RSVP from 'rsvp';

moduleForComponent('dashboards/live/run-commercial', 'Integration | Component | dashboards/live/run-commercial');

const DEFAULT_MAX_AD_BREAK_LENGTH = 180;

test('it renders', function(assert) {
  assert.expect(6);

  let done = assert.async();

  this.set('model', { id: 'foo' });
  this.render(hbs`{{dashboards/live/run-commercial channel=model}}`);

  assert.elementCount(this.$('.loading-spinner'), 1, 'loading spinner is rendered');

  return wait().then(() => {

    assert.elementCount(this.$('.loading-spinner'), 0, 'loading spinner is not rendered');
    assert.elementText(this.$('.form__label'), 'Run Ad', 'Shows up.');
    assert.elementText(this.$('button'), 'Run Ad (0:30)', 'Button shows.');
    assert.equal(this.$('input').attr('max'), 300, 'Slider is configured correctly');
    assert.ok(this.$('.brick').hasClass('hide'), 'Total ads played is hidden');

    return done();
  });
});

test('change commercial length', function(assert) {
  assert.expect(3);

  let done = assert.async();

  this.set('channel', { id: 'foo' });
  this.set('testTrackDashboardEvent', () => {
    assert.ok(true, 'trackDashboardEvent is fired');
  });

  this.render(hbs`
    {{dashboards/live/run-commercial
      channel=channel
      isLive=true
      trackDashboardEvent=testTrackDashboardEvent
    }}
  `);

  wait().then(() => {

    assert.elementText(this.$('button'), 'Run Ad (0:30)', 'Defaut commercial length');

    this.$('input').val(90).change();
  });
  return wait().then(() => {

    assert.elementText(this.$('button'), 'Run Ad (1:30)', 'Changed commercial length');
    return done();
  });
});

test('run a commercial', function(assert) {
  let adsStub = Service.extend({
    getAdBreakSettings() {
      return RSVP.resolve({
        channel_id: 123,
        frequency: 480,
        max_break_length: 180
      });
    },

    startCommercial() {
      return RSVP.resolve({});
    }
  });

  this.register('service:ads', adsStub);

  let done = assert.async();
  assert.expect(4);

  this.set('channel', { id: 'foo' });
  this.set('duration', 2);
  this.set('testTrackDashboardEvent', () => {
    assert.ok(true, 'trackDashboardEvent is fired');
  });

  this.render(hbs`
    {{dashboards/live/run-commercial
      channel=channel
      isLive=true
      duration=duration
      trackDashboardEvent=testTrackDashboardEvent
    }}
  `);

  assert.elementText(this.$('.form__label'), 'Run Ad', 'No previous ads.');
  assert.ok(this.$('.brick').hasClass('hide'), 'Total ads played is hidden');

  this.$('button').click();

  return wait().then(() => {

    assert.elementText(this.$('.brick'), 'Ads played this broadcast: 0:02', 'Total ads played is updated');
    done();
  });
});

test('default max break length', function(assert) {
  let adsStub = Service.extend({
    getAdBreakSettings() {
      return RSVP.reject();
    },

    startCommercial() {
      return RSVP.resolve({});
    }
  });

  this.register('service:ads', adsStub);

  let done = assert.async();

  assert.expect(5);

  this.set('channel', { id: 'foo' });
  this.set('duration', 2);
  this.set('testTrackDashboardEvent', () => {
    assert.ok(true, 'trackDashboardEvent is fired');
  });

  this.render(hbs`
    {{dashboards/live/run-commercial
      channel=channel
      isLive=true
      duration=duration
      trackDashboardEvent=testTrackDashboardEvent
    }}
  `);

  assert.elementText(this.$('.form__label'), 'Run Ad', 'No previous ads.');
  assert.ok(this.$('.brick').hasClass('hide'), 'Total ads played is hidden');
  assert.equal(this.$('input').attr('max'), DEFAULT_MAX_AD_BREAK_LENGTH, 'Slider is configured correctly');

  this.$('button').click();

  return wait().then(() => {

    assert.elementText(this.$('.brick'), 'Ads played this broadcast: 0:02', 'Total ads played is updated');
    done();
  });
});

test('user goes from offline to online', function(assert) {
  assert.expect(4);

  let done = assert.async();

  this.set('channel', { id: 'foo' });
  this.set('isLive', false);
  this.render(hbs`{{dashboards/live/run-commercial channel=channel isLive=isLive}}`);

  return wait().then(() => {

    assert.equal(this.$('input').attr('disabled'), 'disabled', 'input slider is disabled');
    assert.equal(this.$('button').attr('disabled'), 'disabled', 'run commercial button is disabled');

    this.set('isLive', true);

    assert.equal(this.$('input').attr('disabled'), undefined, 'input slider is no longer disabled');
    assert.equal(this.$('button').attr('disabled'), undefined, 'run commercial button is no longer disabled');
    return done();
  });
});
