import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import wait from 'ember-test-helpers/wait';
import Object from 'ember-object';

moduleForComponent('dashboards/live/stream-delay', 'Integration | Component | dashboards/live/stream-delay', {
  beforeEach() {
    let channel = Object.create({
      id: 'foo',
      delay: '300'
    });

    this.set('channel', channel);
  }
});

test('it renders, delay is retrieved', function(assert) {
  let done = assert.async();
  assert.expect(2);

  this.render(hbs`{{dashboards/live/stream-delay channel=channel}}`);

  wait().then(() => {
    assert.elementText(this.$('button'), 'Delay (5min)', 'button displays right delay');
    assert.elementText(this.$('.brick'), 'The stream is delayed by 5 minutes', 'brick displays right delay');

    done();
  });
});

test('change delay value', function(assert) {
  assert.expect(3);

  this.set('testTrackDashboardEvent', () => {
    assert.ok(true, 'trackDashboardEvent is fired');
  });

  this.render(hbs`
    {{dashboards/live/stream-delay
      channel=channel
      isLive=false
      trackDashboardEvent=testTrackDashboardEvent
    }}
  `);

  this.$('input').val(15).change();
  assert.elementText(this.$('button'), 'Delay (15min)', 'button delay updated');
  assert.equal(this.$('input').val(), 15, 'Slider has the right value');
});

test('can update the delay', function(assert) {
  let done = assert.async();
  assert.expect(4);

  this.set('testTrackDashboardEvent', () => {
    assert.ok(true, 'trackDashboardEvent is fired');
  });

  this.render(hbs`
    {{dashboards/live/stream-delay
      channel=channel
      isLive=false
      trackDashboardEvent=testTrackDashboardEvent
    }}
  `);

  this.$('input').val(10).change();

  assert.elementText(this.$('button'), 'Delay (10min)', 'button delay updated');

  this.$('button').click();

  return wait().then(() => {
    assert.elementText(this.$('.brick'), 'The stream is delayed by 10 minutes', 'brick delay updated after click');

    done();
  });
});

test('user goes from offline to online', function(assert) {
  assert.expect(4);

  this.set('channel', { id: 'foo' });
  this.set('isLive', false);

  this.render(hbs`
    {{dashboards/live/stream-delay
      channel=channel
      isLive=isLive
    }}
  `);

  assert.equal(this.$('input').attr('disabled'), undefined, 'input slider is not disabled');
  assert.equal(this.$('button').attr('disabled'), undefined, 'delay button is not disabled');

  this.set('isLive', true);

  assert.equal(this.$('input').attr('disabled'), 'disabled', 'input slider is disabled');
  assert.equal(this.$('button').attr('disabled'), 'disabled', 'delay button is disabled');
});
