import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import wait from 'ember-test-helpers/wait';
import Service from 'ember-service';
import RSVP from 'rsvp';
import Object from 'ember-object';

const SUBSCRIPTIONS_SERVICE_STUB = Service.extend({
  getSubscriberCount() {
    return RSVP.resolve({ count: 9999 });
  }
});

moduleForComponent('dashboards/live/stream-stats', 'Integration | Component | dashboards/live/stream-stats', {
  beforeEach() {
    this.register('service:subscriptions', SUBSCRIPTIONS_SERVICE_STUB);
  }
});

test('renders a non-partner', function(assert) {
  assert.expect(5);

  let done = assert.async();
  let channel = Object.create({
    id: 'foo',
    partner: false,
    followersTotal: 1000,
    views: 10000,
    stream: {
      isOffline: false,
      viewers: 100,
      createdAt: 0,
      _id: 12345678,

      then() {
        return {
          isOffline: false,
          viewers: 100,
          createdAt: 0,
          _id: 12345678
        };
      },

      reload() {
        return RSVP.resolve({
          isOffline: false,
          viewers: 100,
          createdAt: 0,
          _id: 12345678
        });
      }
    }
  });

  this.set('channel', channel);
  this.render(hbs`{{dashboards/live/stream-stats channel=channel isLive=true}}`);

  return wait().then(() => {
    assert.elementText(
      this.$('[data-test-selector="viewer-count"] span'),
      '100 Viewers',
      'correct number of viewers'
    );

    assert.elementText(
      this.$('[data-test-selector="clip-count"] span'),
      '100 Clips',
      'correct number of clips'
    );

    assert.elementText(
      this.$('[data-test-selector="view-count"] span'),
      '10,000 Views',
      'correct number of views'
    );

    assert.elementText(
      this.$('[data-test-selector="follower-count"] span'),
      '1,000 Followers',
      'correct number of followers'
    );

    assert.elementText(
      this.$('[data-test-selector="subscriber-count"] span'),
      '',
      'no subscribers'
    );

    done();
  });
});

test('renders a partner', function(assert) {
  assert.expect(5);

  let done = assert.async();
  let model = Object.create({
    id: 'foo',
    partner: true,
    followersTotal: 1000,
    views: 10000,
    stream: {
      isOffline: false,
      viewers: 100,
      _id: 12345678,

      then() {
        return {
          isOffline: false,
          viewers: 100,
          createdAt: 0,
          _id: 12345678
        };
      },

      reload() {
        return RSVP.resolve({
          isOffline: false,
          viewers: 100,
          createdAt: 0,
          _id: 12345678
        });
      }
    }
  });

  this.set('model', model);

  this.render(hbs`{{dashboards/live/stream-stats channel=model isLive=true}}`);

  return wait().then(() => {
    assert.elementText(
      this.$('[data-test-selector="viewer-count"] span'),
      '100 Viewers',
      'correct number of viewers'
    );

    assert.elementText(
      this.$('[data-test-selector="clip-count"] span'),
      '100 Clips',
      'correct number of clips'
    );

    assert.elementText(
      this.$('[data-test-selector="view-count"] span'),
      '10,000 Views',
      'correct number of views'
    );

    assert.elementText(
      this.$('[data-test-selector="follower-count"] span'),
      '1,000 Followers',
      'correct number of followers'
    );

    assert.elementText(
      this.$('[data-test-selector="subscriber-count"] span'),
      '9,999 Subscribers',
      'correct number of subscribers, commatized'
    );

    done();
  });
});

test('renders an offline partner', function(assert) {
  assert.expect(6);

  let done = assert.async();
  let model = Object.create({
    id: 'baz',
    partner: true,
    followersTotal: 1000,
    views: 10000,
    stream: {
      isOffline: true,
      viewers: 0,

      then() {
        return {
          isOffline: true,
          viewers: 0
        };
      },

      reload() {
        return RSVP.resolve({
          isOffline: true,
          viewers: 0
        });
      }
    }
  });

  this.set('model', model);

  this.render(hbs`{{dashboards/live/stream-stats channel=model isLive=false}}`);

  return wait().then(() => {
    assert.elementText(
      this.$('[data-test-selector="viewer-count"] span'),
      'Offline',
      'no viewers, channel offline'
    );

    assert.elementText(
      this.$('[data-test-selector="up-time"] span'),
      'Offline',
      'no live time, channel offline'
    );

    assert.elementText(
      this.$('[data-test-selector="clip-count"] span'),
      'Offline',
      'correct number of clips'
    );

    assert.elementText(
      this.$('[data-test-selector="view-count"] span'),
      '10,000 Views',
      'correct number of views'
    );

    assert.elementText(
      this.$('[data-test-selector="follower-count"] span'),
      '1,000 Followers',
      'correct number of followers'
    );

    assert.elementText(
      this.$('[data-test-selector="subscriber-count"] span'),
      '9,999 Subscribers',
      'correct number of subscribers, commatized'
    );

    done();
  });
});

test('user goes from offline to online', function(assert) {
  assert.expect(2);

  let done = assert.async();
  let model = Object.create({
    id: 'foo',
    partner: true,
    followersTotal: 1000,
    views: 10000,
    stream: {
      isOffline: false,
      viewers: 100,
      _id: 12345678,

      then() {
        return {
          isOffline: false,
          viewers: 100,
          createdAt: 0,
          _id: 12345678
        };
      },

      reload() {
        return RSVP.resolve({
          isOffline: false,
          viewers: 100,
          createdAt: 0,
          _id: 12345678
        });
      }
    }
  });

  this.set('model', model);
  this.set('isLive', false);
  this.render(hbs`{{dashboards/live/stream-stats channel=model isLive=isLive}}`);

  return wait().then(() => {
    assert.elementText(
      this.$('[data-test-selector="viewer-count"] span'),
      'Offline',
      'no viewers, channel offline'
    );

    this.set('isLive', true);

    return wait();
  }).then(() => {
    assert.elementText(
      this.$('[data-test-selector="viewer-count"] span'),
      '100 Viewers',
      '100 viewers, channel online'
    );

    done();
  });
});
