import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';

moduleForComponent('dashboards/revenue/date-picker', 'Integration | Component | dashboards/revenue/date-picker');

test('it renders', function(assert) {
  assert.expect(5);

  this.set('isDateFilterDisabled', false);
  this.set('testUpdateFunction', () => {
    assert.ok(true, 'Update Revenue Data function called');
  });

  this.render(hbs`
    {{dashboards/revenue/date-picker
      isDateFilterDisabled=isDateFilterDisabled
      updateRevenueData=(action testUpdateFunction)
    }}`);

  assert.notOk(this.$('.balloon-wrapper button').hasClass('button--disabled'), 'drop down selector is not disabled');
  assert.elementText(this.$('.button--dropmenu'), 'Days', 'Days is default selection');

  this.$('.button--dropmenu').click();
  this.$('li:last a').click();

  assert.elementText(this.$('.button--dropmenu'), 'Months', 'Months is now selected');
});
