import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import moment from 'moment';

moduleForComponent('dashboards/revenue/date-picker/date-picker-by-month', 'Integration | Component | dashboards/revenue/date-picker/date-picker-by-month');

test('it renders', function(assert) {
  assert.expect(4);

  this.set('momentStartDate', moment('09-01-2016', 'MM-DD-YYYY').endOf('day').subtract(1, 'month'));
  this.set('momentEndDate', moment('09-01-2016', 'MM-DD-YYYY').endOf('day'));
  this.set('isDateFilterDisabled', false);
  this.set('updateDateFilter', () => {
    assert.ok(true, 'Updated date filter');
  });

  this.render(hbs`
    {{dashboards/revenue/date-picker/date-picker-by-month
      momentStartDate=momentStartDate
      momentEndDate=momentEndDate
      isDatepickerDisabled=isDateFilterDisabled
      updateDateFilter=(action updateDateFilter)
    }}`);

  assert.equal(this.$('.js-datepicker-start').val(), 'Aug 2016', 'Start month is correct');
  assert.equal(this.$('.js-datepicker-end').val(), 'Sep 2016', 'End month is correct');
  assert.elementText(this.$('.dateDistance'), '2 months', 'Month distance is correct');
});
