import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import wait from 'ember-test-helpers/wait';

moduleForComponent('dashboards/revenue/email-subscriber-list-modal', 'Integration | Component | dashboards/revenue/email-subscriber-list-modal');

test('render then cancel modal', function(assert) {
  assert.expect(4);

  this.set('channelId', 'foo');
  this.set('testCloseModal', () => {
    assert.ok(true, 'modal closed');
  });

  this.render(hbs`
    {{dashboards/revenue/email-subscriber-list-modal
      channelId=channelId
      closeModal=(action testCloseModal)
    }}
  `);

  assert.elementText(this.$('h4'), 'Receive Subscriber List', 'Modal title rendered');
  assert.equal(this.$('button').length, 2, 'Two buttons are rendered');
  assert.elementText(this.$('button:first'), 'Cancel', 'Cancel button labeled properly');

  this.$('button:first').click();
});

test('email the list', function(assert) {
  let done = assert.async();
  assert.expect(3);

  this.set('channelId', 'foo');
  this.set('testCloseModal', () => {
    assert.ok(true, 'modal closed');
  });

  this.render(hbs`
    {{dashboards/revenue/email-subscriber-list-modal
      channelId=channelId
      subscriptionsCount=subscriptionsCount
      closeModal=(action testCloseModal)
    }}
  `);

  assert.elementText(this.$('button:last'), 'Send Me Email', 'Send button labeled properly');

  this.$('button:last').click();

  wait().then(() => {
    assert.elementText(this.$('p:first'), 'An email with a CSV attachment is being sent to test@testemail.com.', 'Email sent to right address');
    this.$('button').click();
    done();
  });
});
