import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import wait from 'ember-test-helpers/wait';

moduleForComponent('dashboards/revenue/revenue-container', 'Integration | Component | dashboards/revenue/revenue-container');

test('Rendering revenue-container component', function(assert) {
  let done = assert.async();
  assert.expect(3);

  this.set('channelId', 'foo');
  this.render(hbs`{{dashboards/revenue/revenue-container channelId=channelId}}`);

  wait().then(() => {
    assert.equal(this.$('button:first').text().trim(), 'Days', 'Date selector rendered');
    assert.equal(this.$('h5:first').text().trim(), 'Total Revenue *', 'Revenue totals rendered');
    assert.equal(this.$('.tw-tabs__item').eq(0).text().trim(), 'Revenue', 'Revenue graphs rendered');

    done();
  });
});
