import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';

moduleForComponent('dashboards/revenue/revenue-graphs', 'Integration | Component | dashboards/revenue/revenue-graphs');

test('Render Revenue Graphs', function(assert) {
  assert.expect(7);

  this.set('isRevLoading', true);
  this.set('isSubLoading', true);
  this.set('revenueData', { labels: [], datasets: [] });
  this.set('subscriptionsData', { labels: [], datasets: [] });

  this.render(hbs`
    {{dashboards/revenue/revenue-graphs
      isRevLoading=isRevLoading
      isSubLoading=isSubLoading
      revenueData=revenueData
      subscriptionsData=subscriptionsData
    }}`);

  assert.equal(this.$('.tw-tabs__item').length, 2, 'two tabs are shown');
  assert.ok(this.$('.tw-tabs__item:first > *').hasClass('active'), 'revenue tab is active');
  assert.ok(this.$('.dataWrap .flex__item').hasClass('loading-spinner'), 'loading spinner for revenue chart is displayed');

  this.set('isRevLoading', false);

  assert.equal(this.$('.dataWrap canvas').length, 1, 'revenue chart is rendered');

  this.$('.tw-tabs__item:last a').click();

  assert.ok(this.$('.tw-tabs__item:last > *').hasClass('active'), 'subscriptions tab is active');
  assert.ok(this.$('.dataWrap .flex__item').hasClass('loading-spinner'), 'loading spinner for subscriptions chart is displayed');

  this.set('isSubLoading', false);

  assert.equal(this.$('.dataWrap canvas').length, 1, 'subscriptions chart is rendered');
});
