import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import moment from 'moment';
import hbs from 'htmlbars-inline-precompile';

moduleForComponent('dashboards/revenue/revenue-totals', 'Integration | Component | dashboards/revenue/revenue-totals');

test('revenue totals component displays loading', function(assert) {
  assert.expect(2);

  this.set('isGettingRevenueData', true);
  this.set('compareStartDate', moment('07-01-2016', 'MM-DD-YYYY'));
  this.set('compareEndDate', moment('08-01-2016', 'MM-DD-YYYY'));

  this.render(hbs`
    {{dashboards/revenue/revenue-totals
      isLoading=isGettingRevenueData
      compareStartDate=compareStartDate
      compareEndDate=compareEndDate
    }}`);

  assert.ok(this.$('.revHeader div').hasClass('loading-spinner'), 'Loading spinner is displayed');
  assert.equal(this.$().text().trim(), '', 'No text displayed');
});

test('Hide Bits if not on boarded', function(assert) {
  assert.expect(1);

  this.set('isGettingRevenueData', false);
  this.set('isBitsOnboarded', false);
  this.set('compareStartDate', moment('07-01-2016', 'MM-DD-YYYY'));
  this.set('compareEndDate', moment('08-01-2016', 'MM-DD-YYYY'));

  this.render(hbs`
    {{dashboards/revenue/revenue-totals
      isLoading=isGettingRevenueData
      isBitsOnboarded=isBitsOnboarded
      compareStartDate=compareStartDate
      compareEndDate=compareEndDate
    }}`);

  assert.notEqual(this.$('h5').eq(4).text().trim(), 'Bits Revenue *', 'Bits Column is not present');
});

test('Render the revenue totals component', function(assert) {
  assert.expect(15);

  this.set('isGettingRevenueData', false);
  this.set('rangeSubRevenue', 12345.67);
  this.set('rangeAdRevenue', 1234.56);
  this.set('rangeTPrimeRevenue', 123.45);
  this.set('rangeBitsRevenue', 12.34);
  this.set('compareStartDate', moment('07-01-2016', 'MM-DD-YYYY'));
  this.set('compareEndDate', moment('08-01-2016', 'MM-DD-YYYY'));
  this.set('compareRangeSubRevenue', 10000.00);
  this.set('compareRangeAdRevenue', 2000.00);
  this.set('compareRangeTPrimeRevenue', 100.00);
  this.set('compareRangeBitsRevenue', 20.00);
  this.set('isBitsOnboarded', true);

  this.render(hbs`
    {{dashboards/revenue/revenue-totals
      isLoading=isGettingRevenueData
      rangeSubRevenue=rangeSubRevenue
      rangeAdRevenue=rangeAdRevenue
      rangeTPrimeRevenue=rangeTPrimeRevenue
      rangeBitsRevenue=rangeBitsRevenue
      compareStartDate=compareStartDate
      compareEndDate=compareEndDate
      compareRangeSubRevenue=compareRangeSubRevenue
      compareRangeAdRevenue=compareRangeAdRevenue
      compareRangeTPrimeRevenue=compareRangeTPrimeRevenue
      compareRangeBitsRevenue=compareRangeBitsRevenue
      isBitsOnboarded=isBitsOnboarded
    }}`);

  assert.equal(this.$('.revHeader__dollars').eq(0).text().trim(), '13,716', 'Total dollars match');
  assert.equal(this.$('.revHeader__cents').eq(0).text().trim(), '.02', 'Total cents match');
  assert.equal(this.$('.balloon').eq(0).text().trim(), 'Up from $12,120.00 in previous period (Jul 1, 2016 - Aug 1, 2016)', 'Correct total tooltip');

  assert.equal(this.$('.revHeader__dollars').eq(1).text().trim(), '1,234', 'Ad dollars match');
  assert.equal(this.$('.revHeader__cents').eq(1).text().trim(), '.56', 'Ad cents match');
  assert.equal(this.$('.balloon').eq(1).text().trim(), 'Down from $2,000.00 in previous period (Jul 1, 2016 - Aug 1, 2016)', 'Correct Ad tooltip');

  assert.equal(this.$('.revHeader__dollars').eq(2).text().trim(), '12,345', 'Sub dollars match');
  assert.equal(this.$('.revHeader__cents').eq(2).text().trim(), '.67', 'Sub cents match');
  assert.equal(this.$('.balloon').eq(2).text().trim(), 'Up from $10,000.00 in previous period (Jul 1, 2016 - Aug 1, 2016)', 'Correct Sub tooltip');

  assert.equal(this.$('.revHeader__dollars').eq(3).text().trim(), '123', 'Twitch Prime dollars match');
  assert.equal(this.$('.revHeader__cents').eq(3).text().trim(), '.45', 'Twitch Prime cents match');
  assert.equal(this.$('.balloon').eq(3).text().trim(), 'Up from $100.00 in previous period (Jul 1, 2016 - Aug 1, 2016)', 'Correct Twitch Prime tooltip');

  assert.equal(this.$('.revHeader__dollars').eq(4).text().trim(), '12', 'Bits dollars match');
  assert.equal(this.$('.revHeader__cents').eq(4).text().trim(), '.34', 'Bits cents match');
  assert.equal(this.$('.balloon').eq(4).text().trim(), 'Down from $20.00 in previous period (Jul 1, 2016 - Aug 1, 2016)', 'Correct Bits tooltip');
});
