import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import wait from 'ember-test-helpers/wait';

moduleForComponent('dashboards/revenue/send-email-to-subscribers-modal', 'Integration | Component | dashboards/revenue/send-email-to-subscribers-modal');

test('Render send email to subscribers', function(assert) {
  assert.expect(5);

  this.set('channelId', 'foo');
  this.set('subscriptionsCount', 10);
  this.set('testCloseModal', () => {
    assert.ok(true, 'The modal is closed');
  });

  this.render(hbs`
    {{dashboards/revenue/send-email-to-subscribers-modal
      channelId=channelId
      subscriberCount=subscriptionsCount
      closeModal=(action testCloseModal)
    }}
  `);

  assert.elementText(this.$('h4'), 'Send Email to Subscribers', 'title is correct');
  assert.elementText(this.$('p:first'), 'Use this form to send a message to all 10 of your active subscribers.', 'number of subs is displayed');
  assert.elementText(this.$('button:first'), 'Cancel', 'Cancel button rendered');
  assert.elementText(this.$('button:last'), 'Send Email', 'Send button displays correct text');
  assert.ok(this.$('button:last').hasClass('button--disabled'), 'Send button is disabled');

  this.$('button.first').click();
});

test('Cancel unfinished message', function(assert) {
  assert.expect(5);

  this.set('channelId', 'foo');
  this.set('subscriptionsCount', 10);
  this.set('testCloseModal', () => {
    assert.ok(true, 'The modal is closed');
  });

  this.render(hbs`
    {{dashboards/revenue/send-email-to-subscribers-modal
      channelId=channelId
      subscriberCount=subscriptionsCount
      closeModal=(action testCloseModal)
    }}
  `);

  assert.ok(this.$('button:last').hasClass('button--disabled'), 'Send button is disabled');

  this.$('input').val('test title');
  this.$('input').change();

  assert.ok(this.$('button:last').hasClass('button--disabled'), 'Send button is still disabled');

  this.$('textarea').val('test body');
  this.$('textarea').change();

  assert.notOk(this.$('button:last').hasClass('button--disabled'), 'Send button enabled');

  this.$('button:first').click();

  assert.elementText(this.$('.inline-warning'), 'You have an unsent draft. Closing this form will discard your changes.', 'Warning displayed');

  this.$('button:first').click();
});

test('Send email to subscribers', function(assert) {
  let done = assert.async();
  assert.expect(3);

  this.set('channelId', 'foo');

  this.render(hbs`
    {{dashboards/revenue/send-email-to-subscribers-modal
      channelId=channelId
    }}
  `);

  this.$('input').val('test title');
  this.$('input').change();
  this.$('textarea').val('test body');
  this.$('textarea').change();

  assert.notOk(this.$('button:last').hasClass('button--disabled'), 'Send button enabled');

  this.$('button:last').click();

  wait().then(() => {
    assert.elementText(this.$('p'), 'Your email has been sent!', 'email successfully sent');
    assert.elementText(this.$('button'), 'Close', 'Close button is rendered');
    done();
  });
});
