import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import wait from 'ember-test-helpers/wait';
import Service from 'ember-service';
import RSVP from 'rsvp';

const CHANNEL_LOGIN = 'foo';

moduleForComponent('dashboards/revenue/subscriptions-count', 'Integration | Component | dashboards/revenue/subscriptions-count');

test('Render Subscriptions Count: Retrieve Subscribers', function(assert) {
  assert.expect(4);

  let done = assert.async();
  let count = 9999;
  let subscriptionsServiceStub = Service.extend({
    getSubscriberCount({ channelLogin }) {
      assert.ok(true, `Subscriptions service's #getSubscriberCount function is invoked`);
      assert.equal(channelLogin, CHANNEL_LOGIN, 'channel login is passed');

      return RSVP.resolve({ count });
    }
  });

  this.register('service:subscriptions', subscriptionsServiceStub);
  this.set('channelId', CHANNEL_LOGIN);

  this.render(hbs`{{dashboards/revenue/subscriptions-count channelId=channelId}}`);

  return wait().then(() => {
    assert.elementText(this.$('h4'), 'Subscriptions', 'Component is rendered');

    assert.elementText(
      this.$('p').eq(0),
      `You currently have 9,999 subscribers`,
      'subscriber count is retrieved and commatized'
    );

    done();
  });
});

test('Subscriptions Count click on modal action links', function(assert) {
  assert.expect(3);

  let done = assert.async();

  this.set('channelId', CHANNEL_LOGIN);

  this.render(hbs`
    {{dashboards/revenue/subscriptions-count channelId=channelId}}
    <div id="wormhole-overlays"></div>
  `);

  return wait().then(() => {
    assert.elementText(this.$('.card'), '', 'Both modals are not shown');

    this.$('a').eq(0).click();

    assert.elementText(this.$('.card h4'), 'Receive Subscriber List', 'Email List of Subscribers modal is now shown');

    this.$('a').eq(1).click();

    assert.elementText(this.$('.card h4'), 'Send Email to Subscribers', 'Send Email to Subscribers modal is now shown');

    done();
  });
});
