import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import wait from 'ember-test-helpers/wait';

moduleForComponent('dashboards/revenue/teespring-campaign', 'Integration | Component | dashboards/revenue/teespring-campaign');

test('User has no Teespring campaigns', function(assert) {
  let done = assert.async();
  assert.expect(1);

  this.set('channelId', 'baz');
  this.render(hbs`{{dashboards/revenue/teespring-campaign channelId=channelId}}`);

  wait().then(() => {
    assert.equal(this.$().text().trim(), '', 'Nothing is rendered');
    done();
  });
});

test('User has multiple Teespring campaigns', function(assert) {
  let done = assert.async();
  assert.expect(8);

  this.set('channelId', 'foo');
  this.render(hbs`{{dashboards/revenue/teespring-campaign channelId=channelId}}`);

  wait().then(() => {
    assert.equal(this.$('h4').eq(0).text().trim(), 'Teespring Revenue', 'Component is rendered');
    assert.equal(this.$('.revHeader__dollars').text().trim(), '600', 'Total Revenue dollars is correct');
    assert.equal(this.$('.revHeader__cents').text().trim(), '.00', 'Total Revenue cents is correct');
    assert.equal(this.$('h1').eq(1).text().trim(), '3', 'Total Campaigns is the right number');

    assert.equal(this.$('a').eq(1).attr('href'), 'http://campaign_url_0', 'Campaign 0 url is correct');
    assert.equal(this.$('img').eq(0).attr('src'), 'http://image_url_0', 'Campaign 0 img is correct');
    assert.equal(this.$('.teeMeta__description').eq(0).text().trim(), 'Campaign 0', 'Campaign 0 name is correct');
    assert.equal(this.$('.teeMeta__title').eq(0).text().trim(), '$100', 'Campaign 0 revenue is correct');

    done();
  });
});
