import { test } from 'ember-qunit';
import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import hbs from 'htmlbars-inline-precompile';
import wait from 'ember-test-helpers/wait';

moduleForComponent('dashboards/settings/stream-key', 'Integration | Component | dashboards/settings/stream-key');

test('opens and closes modal window', function(assert) {
  assert.expect(3);

  this.set('userId', 'twitch');

  this.render(hbs`
    {{dashboards/settings/stream-key userId=userId}}
    <div id="wormhole-overlays"></div>
  `);

  assert.elementCount(this.$('.twitch_subwindow_container'), 0, 'modal is hidden');

  this.$('button').click();

  assert.elementCount(this.$('.twitch_subwindow_container'), 1, 'modal is open');

  this.$('.modal-close-button').click();

  assert.elementCount(this.$('.twitch_subwindow_container'), 0, 'modal is closed');
});

test('retrieves the stream key', function(assert) {
  assert.expect(3);

  let done = assert.async();

  this.set('userId', 'twitch');

  this.render(hbs`
    {{dashboards/settings/stream-key userId=userId}}
    <div id="wormhole-overlays"></div>
  `);

  this.$('button').click();

  assert.elementText(this.$('[data-test-selector="stream-key"]'), '', 'stream key is hidden');

  this.$('.card .button').click();

  return wait().then(() => {
    assert.elementText(this.$('[data-test-selector="stream-key"]'), 'live_123abc456def', 'stream key is shown');

    this.$('.card .button').click();

    return wait();
  }).then(() => {
    assert.elementText(this.$('[data-test-selector="stream-key"]'), 'live_123abc999ggg', 'new stream key is provided');

    done();
  });
});
