import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import moduleForComponent from 'web-client/tests/helpers/module-for-component';

import { BadgesPage } from 'web-client/tests/pages/dashboards/subscription-dash';

const IMG_SRC = '#test';
const NAME = 'Badge!';
const TITLE = 'Test Title';

moduleForComponent('dashboards/subscription-dash/badges/badge-display', 'Integration | Component | dashboards/subscription-dash/badges/badge display', {
  integration: true,

  beforeEach() {
    this.set('name', NAME);

    this.page = BadgesPage.create();
  }
});

test('it renders with the correct tags and classes', function (assert) {
  assert.expect(2);

  this.render(hbs`
    {{dashboards/subscription-dash/badges/badge-display name=name}}
  `);

  let $figure = this.$(this.page.subBadgeDisplayFigure());
  let $figcaption = this.$(this.page.subBadgeDisplayFigcaption());

  assert.elementCount($figure, 1, '<figure> is rendered');
  assert.elementText($figcaption, NAME, '<figcaption> balloon has the passed-in "name"');
});

test('it renders an <img> and tooltip when "badge" is passed-in', function (assert) {
  assert.expect(9);

  this.render(hbs`
    {{dashboards/subscription-dash/badges/badge-display imgSrc=imgSrc name=name title=title}}
  `);

  let $figure = this.$(this.page.subBadgeDisplayFigure());
  let $img = this.$(this.page.subBadgeDisplayImage());
  let $tooltip = this.$(this.page.subBadgeDisplayTooltip());

  assert.notOk($figure.hasClass('balloon-wrapper'), '<figure> is not a balloon wrapper');
  assert.elementCount($img, 0, '<img> is NOT rendered');
  assert.elementCount($tooltip, 0, 'balloon tooltip is NOT rendered');

  this.set('imgSrc', IMG_SRC);
  this.set('title', TITLE);

  $figure = this.$(this.page.subBadgeDisplayFigure());
  $img = this.$(this.page.subBadgeDisplayImage());
  $tooltip = this.$(this.page.subBadgeDisplayTooltip());

  assert.ok($figure.hasClass('balloon-wrapper'), '<figure> is a balloon wrapper');

  assert.elementCount($img, 1, '<img> is rendered');
  assert.equal($img.attr('src'), IMG_SRC, '<img> "src" attribute is set');
  assert.equal($img.attr('alt'), TITLE, '<img> "title" attribute is set');

  assert.elementCount($tooltip, 1, 'balloon tooltip is rendered');
  assert.elementText($tooltip, TITLE, 'balloon tooltip text is set');
});
