import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import moduleForComponent from 'web-client/tests/helpers/module-for-component';

const TAB_NAME = 'Test Tab Name';

moduleForComponent('dashboards/subscription-dash/badges/tabs-item', 'Integration | Component | dashboards/subscription-dash/badges/tabs item', {
  integration: true,

  beforeEach() {
    this.set('isActive', false);
    this.set('tabName', TAB_NAME);
    this.set('onTabSelect', () => {});
  }
});

test('it renders with the correct tags and classes', function (assert) {
  assert.expect(3);

  this.render(hbs`
    {{#dashboards/subscription-dash/badges/tabs-item
      isActive=isActive
      name=tabName
      select=onTabSelect}}
      {{i18n tabName}}
    {{/dashboards/subscription-dash/badges/tabs-item}}
  `);

  assert.notOk(this.$('.js-sub-badge-tab').hasClass('active'), 'component tab button is NOT active');
  assert.elementText(this.$('.js-sub-badge-tab'), TAB_NAME, 'button has the passed-in "name"');

  this.set('isActive', true);

  assert.ok(this.$('.js-sub-badge-tab').hasClass('active'), 'component tab button has toggled "active" class');
});

test('it invokes the closure action "select" on tab/button click', function (assert) {
  assert.expect(1);

  let onTabSelect = () => {
    assert.ok(true, 'closure action is invoked on button click');
  };

  this.set('onTabSelect', onTabSelect);

  this.render(hbs`
    {{#dashboards/subscription-dash/badges/tabs-item
      isActive=isActive
      name=tabName
      select=onTabSelect}}
      {{i18n tabName}}
    {{/dashboards/subscription-dash/badges/tabs-item}}
  `);

  this.$('button').click();
});
