import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';

moduleForComponent('dashboards/subscription-dash/contract-amendment-confirmation/component',
  'Integration | Component | dashboards/subscription--dash/contract-amendment-confirmation/component', {
});

test('it renders the strings passed in.', function(assert) {
  this.set('closeAction', () => {});

  this.render(hbs`{{dashboards/subscription-dash/contract-amendment-confirmation
          closeAmendmentModal=(action closeAction)
          amendmentConfirmationTitle="title"
          amendmentConfirmationMessaging="messaging"
          amendmentConfirmationCancel="cancel"
          amendmentConfirmationContinue="continue"
        }}`);

  //Remove newlines and duplicate spaces to make the 'expected' result readable.
  assert.equal(this.$().text().trim().replace(/(?:\r\n|\r|\n)/g, '').replace(/ +(?= )/g,''), 'title messaging cancel continue');

});

test('it bubbles cancel / continue actions up to provided action', function(assert) {
  let closeActionCalled = 0;
  let closeActionValue = null;
  this.set('closeAction', (continuing) => {
    closeActionCalled++;
    closeActionValue = continuing;
  });

  this.render(hbs`{{dashboards/subscription-dash/contract-amendment-confirmation
          closeAmendmentModal=(action closeAction)
          amendmentConfirmationTitle="title"
          amendmentConfirmationMessaging="messaging"
          amendmentConfirmationCancel="cancel"
          amendmentConfirmationContinue="continue"
        }}`);
  this.$('.js-subwindow-close').click();
  assert.equal(closeActionCalled, 1, 'Close Action Called');
  assert.equal(closeActionValue, false, 'False passed when canceling');

  this.$('.js-subwindow-submit').click();
  assert.equal(closeActionCalled, 2, 'Close Action Called a second time');
  assert.equal(closeActionValue, true, 'True passed when continuing');

});
