import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import wait from 'ember-test-helpers/wait';

moduleForComponent('dashboards/subscription-dash/contract-amendment/component', 'Integration | Component | dashboards/subscription-dash/contract-amendment/component', {
});

test('it renders contract language', function(assert) {
  this.set('closeAmendment', function(){});
  this.render(hbs`
    {{#dashboards/subscription-dash/contract-amendment closeAmendmentModal=closeAmendment}}
      <p>Contract Text Goes Here</p>
    {{/dashboards/subscription-dash/contract-amendment}}
  `);

  assert.equal(this.$().text().trim(), 'Contract Text Goes Here');
});

test('it tracks scroll for hasReadAgreement', function(assert) {
  assert.expect(2);

  this.set('closeAmendment', function(){});
  this.render(hbs`
    {{#dashboards/subscription-dash/contract-amendment closeAmendmentModal=closeAmendment}}
      <br /><br /><br /><br /><br /><br /><br /><br /><br /><br />
    {{/dashboards/subscription-dash/contract-amendment}}
  `);

  assert.equal(this.$('.js-subwindow-submit').prop('disabled'), true);
  this.$('.contract-amendments-window').scrollTop(1000);
  return wait().then(() => {
    assert.equal(this.$('.js-subwindow-submit').prop('disabled'), false);
  });

});

