import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import moduleForComponent from 'web-client/tests/helpers/module-for-component';

const HEADER = 'Awsome Section Header!';
const DESCRIPTION = 'Awsome Section Description!';
const TARGET = '#';

const CHECKMARK_SELECTOR = 'td.list-status figure.checkmark';
const HEADER_SELECTOR = 'td.list-features h5';
const DESCRIPTION_SELECTOR = 'td.list-features p.sub-text';

moduleForComponent('dashboards/subscription-dash/section-row', 'Integration | Component | dashboards/subscription-dash/section-row', {
  beforeEach() {
    this.set('header', HEADER);
    this.set('description', DESCRIPTION);
  }
});

test('it renders with a header and a description', function (assert) {
  assert.expect(2);

  this.render(hbs`
    {{dashboards/subscription-dash/section-row
      header=header
      description=description}}
  `);

  assert.elementText(this.$(HEADER_SELECTOR), HEADER, 'section header is rendered');
  assert.elementText(this.$(DESCRIPTION_SELECTOR), DESCRIPTION, 'section description is rendered');
});

test('it toggles the checkmark figure', function (assert) {
  assert.expect(2);

  this.render(hbs`
    {{dashboards/subscription-dash/section-row
      header=header
      description=description
      isChecked=isChecked}}
  `);

  assert.ok(this.$(CHECKMARK_SELECTOR).hasClass('inactive'), 'checkmark is inactive by default');

  this.set('isChecked', true);

  assert.notOk(this.$(CHECKMARK_SELECTOR).hasClass('inactive'), 'checkmark is NOT inactive');
});

test('it renders one of three types of header', function (assert) {
  assert.expect(7);

  let anchorSelector = `${ HEADER_SELECTOR } a`;
  let anchor;

  this.render(hbs`
    {{dashboards/subscription-dash/section-row
      header=header
      description=description
      linkToTarget=linkToTarget
      isLinkToTargetExternal=isLinkToTargetExternal}}
  `);

  anchor = this.$(anchorSelector);

  assert.elementCount(anchor, 0, 'header is not a hyperlink');

  this.set('linkToTarget', TARGET);

  anchor = this.$(anchorSelector);

  assert.elementText(anchor, HEADER, 'header text is still set');
  assert.elementCount(anchor, 1, 'header is a hyperlink');
  assert.ok(anchor.hasClass('ember-view'), 'anchor is an Ember link-to component');

  this.set('isLinkToTargetExternal', true);

  anchor = this.$(anchorSelector);

  assert.elementText(anchor, HEADER, 'header text is still set');
  assert.equal(anchor.attr('href'), TARGET, 'anchor href is set');
  assert.notOk(anchor.hasClass('ember-view'), 'anchor is NOT an Ember link-to component');
});
