import { test } from 'ember-qunit';
import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import hbs from 'htmlbars-inline-precompile';
import { AuthenticatedSession } from 'web-client/tests/helpers/mock-session-service';
import { getTimeSeriesData } from 'web-client/mirage/fixtures/video-stats-timeseries';
import DetailsReport, { DEFAULT_METRIC } from 'web-client/utilities/video-stats/details-report';
import FakeSearch from 'web-client/tests/helpers/fake-search';

const TODAY = new Date(1991, 3, 7);

moduleForComponent('dashboards/video-stats/details', 'Integration | Component | dashboards/video-stats/details', {
  integration: true,
  beforeEach() {
    this.report = DetailsReport.create({
      today: TODAY,
      data: getTimeSeriesData()
    });

    this.owner.register('service:search', FakeSearch);
    this.owner.register('service:session', AuthenticatedSession);
    this.inject.service('session');
    this.inject.service('search');
    this.set('report', this.report);
    this.set('today', TODAY);

    this.defaultTemplate = hbs`{{dashboards/video-stats/details report=report today=today}}`;
  }
});

test('when the component is rendered', function(assert) {
  this.render(this.defaultTemplate);
  let selectedOption = this.$('.js-metric-selector');

  assert.equal(selectedOption.val(), 'viewcount', 'should select the proper default');
});

test('selecting a metric', function(assert) {
  this.render(this.defaultTemplate);

  this.$(`.js-metric-selector option[value="${DEFAULT_METRIC}"]`).attr('selected', 'selected');
  this.$(`.js-metric-selector`).change();

  assert.equal(this.report.get('selectedMetric'), DEFAULT_METRIC, "should update the report's selectedMetric");
});

test('selecting a filter', function(assert) {
  let expectedFilter = 'country';
  this.render(this.defaultTemplate);

  this.$(`.js-filter-selector option[value="${expectedFilter}"]`).attr('selected', 'selected');
  this.$(`.js-filter-selector`).change();
  let filterTableTitle = this.$('.js-summary-table__title:contains(Country Totals)');

  assert.equal(this.report.get('selectedFilter'), expectedFilter, "should update the report's selectedFilter");
  assert.equal(filterTableTitle.length, 1, 'should set the proper table title for the metric');
});

test('selecting a filter when the averageviewduration is the selected metric', function(assert) {
  this.report.set('selectedMetric', 'averageviewduration');
  this.report.set('selectedFilter', 'country');

  assert.elementCount('.js-video-stats__filter-table', 0, 'should not show the filter table');
});
