import { test } from 'ember-qunit';
import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import hbs from 'htmlbars-inline-precompile';
import { AuthenticatedSession } from 'web-client/tests/helpers/mock-session-service';
import FakeSearch from 'web-client/tests/helpers/fake-search';
import DeprecatedVideo from 'web-client/models/deprecated-video';

const VIDEO_ID = 'v1234';

moduleForComponent('dashboards/video-stats/header', 'Integration | Component | dashboards/video-stats/header', {
  beforeEach() {
    this.owner.register('service:session', AuthenticatedSession);
    this.owner.register('service:search', FakeSearch);
    this.inject.service('session');
    this.inject.service('search');


    this.defaultTemplate = hbs`{{dashboards/video-stats/header video=video}}`;
  }
});

test('when a video is passed to the component', function(assert) {
  this.set('video', DeprecatedVideo.create({
    _id: VIDEO_ID,
    recorded_at: new Date(1991, 3, 7),
    published_at: new Date(1991, 3, 7),
    broadcast_type: 'archive'
  }));
  this.render(this.defaultTemplate);

  assert.ok(this.$('.js-video-stats__video-header').length > 0, 'should show the video-header');
});

test('when a video is passed to the component', function(assert) {
  this.render(this.defaultTemplate);

  assert.elementCount(this.$('.js-video-stats__video-header'), 0, 'should not show the video-header');
});
