import { test } from 'ember-qunit';
import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import hbs from 'htmlbars-inline-precompile';

const TITLE = 'Table Title';
const FILTER = 'filter';
const DATA = {
  getAnalyticsByFilter: () => ([
    { key: 'Canada', viewcount: 45, minuteswatched: 12 },
    { key: 'USA', viewcount: 12, minuteswatched: 20 },
    { key: 'China', viewcount: 2, minuteswatched: 15 },
    { key: 'Germany', viewcount: 0, minuteswatched: 0 }
  ])
};

moduleForComponent('dashboards/video-stats/stats-table', 'Integration | Component | dashboards/video-stats/stats-table', {
  beforeEach() {
    this.set('data', DATA);
    this.set('title', TITLE);
    this.set('filter', FILTER);
    this.set('tooltip', '');

    this.defaultTemplate = hbs`
      {{dashboards/video-stats/stats-table title=title filter=filter data=data tooltip=tooltip limit=3}}
    `;
  }
});

test('rendering the stats-table', function(assert) {
  this.render(this.defaultTemplate);

  assert.equal(this.$('h3').text().trim(), TITLE, 'should set the title properly');
  assert.equal(this.$('tbody tr').length, 3, 'should render a number of rows according to the limit');

  let tableData = this.$('tbody tr').toArray().map(tr => tr.textContent.trim().replace(/\s+/g, " "));
  assert.deepEqual(tableData, [
    'USA 12 20',
    'China 2 15',
    'Canada 45 12'
  ], 'should render the data rows in descending order of viewcount');

  assert.notOk(this.$('.js-video-stats__table-tip').length, 'should hide the tooltip icon if not set');
});

test('when a tooltip is provided', function(assert) {
  let tooltip = 'Awesome tooltip!';
  this.set('tooltip', tooltip);
  this.render(this.defaultTemplate);

  assert.ok(this.$('.js-video-stats__table-tip').length, 'should show the tooltip icon');
});
