import { test } from 'ember-qunit';
import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import hbs from 'htmlbars-inline-precompile';

const VIDEO = {
  title: 'Video Title',
  url: 'https://twitch.tv/v/1234',
  created_at: new Date(1991, 3, 7),
  broadcast_type: 'archive'
};

moduleForComponent('dashboards/video-stats/video-header', 'Integration | Component | dashboards/video-stats/video-header', {
  beforeEach() {
    this.set('video', VIDEO);
    this.defaultTemplate = hbs`{{dashboards/video-stats/video-header video=video}}`;
  }
});

test('rendering the video header', function(assert) {
  this.render(this.defaultTemplate);

  assert.equal(this.$('h3').text().trim(), VIDEO.title, 'should set the title properly');
  assert.equal(this.$('p').text().trim(), 'Archive published April 7, 1991');
});
