import { test } from 'ember-qunit';
import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import hbs from 'htmlbars-inline-precompile';

const CREATED_AT = new Date(1991, 3, 7);

const VIDEO = {
  objectID: '1234',
  thumbnail: 'https://twitch.tv/404',
  title: 'Doin The Do',
  created_at: CREATED_AT.toString(),
  broadcaster_login: 'lirik',
  broadcaster_name: 'lirik'
};

moduleForComponent('dashboards/video-stats/video-search-card', 'Integration | Component | dashboards/video-stats/video-search-card', {
  beforeEach() {
    this.set('video', VIDEO);
    this.defaultTemplate = hbs`{{dashboards/video-stats/video-search-card video=video}}`;
    this.render(this.defaultTemplate);
  }
});

test('rendering', function(assert) {
  assert.equal(this.$('img').attr('src'), VIDEO.thumbnail, 'should set the thumbnail image source');
  assert.ok(this.$('p:contains(April 7, 1991)'), 'should properly format the creation date');
});
