import { test } from 'ember-qunit';
import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import hbs from 'htmlbars-inline-precompile';
import wait from 'ember-test-helpers/wait';
import { AuthenticatedSession } from 'web-client/tests/helpers/mock-session-service';
import FakeSearch from 'web-client/tests/helpers/fake-search';

moduleForComponent('dashboards/video-stats/video-search', 'Integration | Component | dashboards/video-stats/video-search', {
  beforeEach() {
    this.owner.register('service:session', AuthenticatedSession);
    this.owner.register('service:search', FakeSearch);
    this.inject.service('session');
    this.inject.service('search');

    this.defaultTemplate = hbs`{{dashboards/video-stats/video-search video=video ownerLogin='twitch'}}`;
  }
});

const ESC_KEY = 27;

test('when no results are returned', function(assert) {
  assert.expect(2);

  this.render(this.defaultTemplate);

  return wait().then(() => {
    let searchResult = this.$('.js-video-stats-search__result');

    assert.notOk(searchResult.length > 0, 'no search results should exist');
    assert.elementText('.js-video-stats-search__title', 'No results found.', 'should display the no results found element');
  });
});

test('when results are returned but no input has been entered', function(assert) {
  assert.expect(3);

  let videoTitle = 'foo123';
  this.get('search').setProperties({ videos: [{ title: videoTitle }] });
  this.render(this.defaultTemplate);

  return wait().then(() => {
    let searchResult = this.$('.js-video-stats-search__result');

    assert.ok(searchResult, 'a search result should exist');
    assert.elementText('.js-video-stats-search__title', 'Recent Videos', 'should display the no results found element');
    assert.elementText('.js-video-stats-search__result', new RegExp(videoTitle), 'a search result should exist');
  });
});

test('when an input is provided for the search bar', function(assert) {
  assert.expect(3);

  let videoTitle = 'foo123';
  this.get('search').setProperties({ videos: [{ title: videoTitle }] });
  this.render(this.defaultTemplate);
  this.$('.js-video-stats-search__input').val('123');
  this.$('.js-video-stats-search__input').trigger('input', { target: { value: '123' }});

  return wait().then(() => {
    assert.elementText('.js-video-stats-search__title', 'Search Results', 'should display the proper title');
    assert.ok(this.$('.js-video-stats-search__result').length > 0, 'a search result should exist');
    assert.elementText('.js-video-stats-search__result', new RegExp(videoTitle), 'a search result should exist');
  });
});

test('when search box is hovered', function(assert) {
  assert.expect(6);

  this.render(this.defaultTemplate);
  assert.strictEqual(this.$('.balloon.hide').length, 1, ' should start hidden');
  assert.strictEqual(this.$('.balloon.show').length, 0, ' should start hidden');

  this.$('.balloon-wrapper').mouseenter();
  assert.strictEqual(this.$('.balloon.show').length, 1, ' should show on mouseenter');
  assert.strictEqual(this.$('.balloon.hide').length, 0, ' should show on mouseenter');

  this.$('.balloon-wrapper').mouseleave();
  assert.strictEqual(this.$('.balloon.hide').length, 1, ' should hide on mouseleave');
  assert.strictEqual(this.$('.balloon.show').length, 0, ' should hide on mouseleave');
});

test('when search box is focused', function(assert) {
  assert.expect(6);

  this.render(this.defaultTemplate);
  assert.strictEqual(this.$('.balloon.hide').length, 1, ' should start hidden');
  assert.strictEqual(this.$('.balloon.show').length, 0, ' should start hidden');

  this.$('.balloon-wrapper').focusin();
  assert.strictEqual(this.$('.balloon.show').length, 1, ' should show on focus');
  assert.strictEqual(this.$('.balloon.hide').length, 0, ' should show on focus');

  let event = $.Event('keydown', { keyCode: ESC_KEY });
  $('.balloon-wrapper').trigger(event);
  assert.strictEqual(this.$('.balloon.hide').length, 1, ' should hide on escape key');
  assert.strictEqual(this.$('.balloon.show').length, 0, ' should hide on escape key');
});
