import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import Helper from 'ember-helper';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import GamesPage from 'web-client/tests/pages/directory/games';

const { helper } = Helper;
let page;

moduleForComponent('directory-featured-games', {
  beforeEach() {
    this.routeActionInvocations = [];
    this.owner.register('helper:route-action', helper(([...args]) => {
      return (...invocationArgs) => {
        this.routeActionInvocations.push(args.concat(invocationArgs));
      };
    }));

    page = GamesPage.create();
    this.game = this.server.create('featured-game');
    this.set('game', this.game);
    this.defaultTemplate = hbs`
      {{directory-featured-game model=game
        tt_content_index=1
        tt_medium="twitch_home"
        tt_content="featured_games"
        location="front_page"}}`;
  }
});

test('renders featured games', function(assert) {
  assert.expect(3);
  this.render(this.defaultTemplate);

  assert.elementCount(page.promotedGame(this.game.name), 1, 'rendered game name');
  assert.elementCount(page.promotedClickUrl(this.game.trackingUrls.clickthroughUrl), 1, 'rendered clickthroughUrl');
  assert.elementCount(page.promotedTrackingPixel(this.game.trackingUrls.trackingPixelUrl), 1, 'rendered trackingPixelUrl');
});

test('calls promoted game handler action', function(assert) {
  assert.expect(1);
  this.render(this.defaultTemplate);

  this.$(page.promotedClickUrl(this.game.trackingUrls.clickthroughUrl)).click();
  let routeActionInvocation = this.routeActionInvocations[0];
  assert.deepEqual(routeActionInvocation, [
    'handlePromotedGameClick',
    this.game,
    'front_page'
  ], 'called action on click');
});
