import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import wait from 'ember-test-helpers/wait';
import { loadGameDetail } from 'web-client/tests/integration/components/directory/game-details/game-detail-helper';

moduleForComponent('directory/game-details', 'Integration | Component | directory/game details', {
  beforeEach() {
    this.store = this.owner.lookup('service:store');
    this.loadGameDetail = loadGameDetail;
  }
});

test('renders w/ videos and images', function (assert) {
  assert.expect(8);

  this.loadGameDetail({
    product: {
      title: 'The Game',
      feature_details: [],
      media: {
        videos: [
          { video_id: 'v123' }
        ],
        screenshot_urls: [ 'url' ]
      }
    }
  });
  this.render(hbs`
    {{directory/game-details
      gameDetail=gameDetail}}`);

  return wait().then(() => {
    let $sections = this.$('.game-details__section');
    let $getGame = $sections.eq(0);
    let $videos = $sections.eq(1);
    let $blurbOne = $sections.eq(2);
    let $gallery = $sections.eq(3);
    let $description = $sections.eq(4);

    assert.elementCount($sections, 5, '5 sections');
    assert.elementCount($getGame.find('.js-game-details-get-game'), 1, 'game-details/get-game-card component rendered');
    assert.elementCount($videos.find('.js-game-details-videos'), 1, 'game-details/videos component rendered');
    assert.elementCount($blurbOne.find('.js-game-details-features'), 1, 'game-details/features component rendered');
    assert.elementCount($blurbOne.find('.js-game-details-game-information'), 1, 'game-details/game-information component rendered');
    assert.elementCount($blurbOne.find('.js-game-details-pc-requirements'), 1, 'game-details/pc-requirements component rendered');
    assert.elementCount($gallery.find('.js-game-details-gallery'), 1, 'game-details/gallery component rendered');
    assert.elementCount($description.find('.js-game-details-description'), 1, 'game-details/description component rendered');
  });
});

// TODO: Test 'hasSpaceForSidebar' and kinda alternating grey/white sections
