import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import wait from 'ember-test-helpers/wait';

moduleForComponent('directory/game-details/features', 'Integration | Component | directory/game details/features');

test('it renders', function (assert) {
  assert.expect(4);

  this.product = {
    feature_details: [ 'hello', 'world' ]
  };
  this.render(hbs`{{directory/game-details/features product=product}}`);

  return wait().then(() => {
    assert.elementText(this.$('.game-details__section-title'), 'Features', 'section title');

    let $features = this.$('li');
    assert.elementCount($features, 2, '2 features');
    assert.elementText($features.eq(0), 'hello');
    assert.elementText($features.eq(1), 'world');
  });
});
