import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import wait from 'ember-test-helpers/wait';
import sinon from 'sinon';

moduleForComponent('directory/game-details/gallery', 'Integration | Component | directory/game details/gallery');

test('it renders', function (assert) {
  assert.expect(3);

  let flexsliderStub = sinon.stub($, 'flexslider');
  this.images = [
    'url1', 'url2', 'url3'
  ];
  this.render(hbs`{{directory/game-details/gallery imageUrls=images}}`);

  return wait().then(() => {
    assert.elementText(this.$('.game-details__section-title'), 'Gallery', 'section title');
    assert.elementCount(this.$('.game-details__slideshow'), 3, '3 images rendered');
    assert.ok(flexsliderStub.called, 'flexslider was created for the carousel');

    flexsliderStub.restore();
  });
});
