import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';

moduleForComponent('directory/game-details/game-information', 'Integration | Component | directory/game details/game information');

test('renders with all info', function (assert) {
  this.product = {
    title: 'Gaem',
    genres: ['axn'],
    developer_name: 'Yandere',
    publisher_name: 'Gaben',
    website_url: 'https://www.twitch.tv',
    eula_url: 'https://www.twitch.tv/eula',
    support_url: 'https://www.twitch.tv/support'
  };
  this.render(hbs`{{directory/game-details/game-information product=product}}`);

  let $details = this.$('.specification__list .js-game-details-detail');
  let $title = $details.eq(0);
  let $genres = $details.eq(1);
  let $dev = $details.eq(2);
  let $pub = $details.eq(3);
  let $website = $details.eq(4);
  let $eula = $details.eq(5);
  let $support = $details.eq(6);

  assert.elementText(this.$('.game-details__section-title'), 'Information');
  assert.elementCount($details, 7, '7 details');

  assert.elementText($title, /Title\:.+/, 'title label');
  assert.elementText($title, /.+Gaem/, 'title content');

  assert.elementText($genres, /Genre\:.+/, 'genres label');
  assert.elementText($genres, /.+axn/, 'genres content');

  assert.elementText($dev, /Developer\:.+/, 'developer label');
  assert.elementText($dev, /.+Yandere/, 'developer content');

  assert.elementText($pub, /Publisher\:.+/, 'publisher label');
  assert.elementText($pub, /.+Gaben/, 'publisher content');

  assert.elementText($website, /More Info\:.+/, 'website link label');
  assert.elementText($website.find('a'), 'Website', 'website link text');
  assert.equal($website.find('a').attr('href'), 'https://www.twitch.tv', 'website url');

  assert.elementText($eula, /License Agreement\:.+/, 'eula link label');
  assert.elementText($eula.find('a'), 'Check out the EULA', 'eula link text');
  assert.equal($eula.find('a').attr('href'), 'https://www.twitch.tv/eula', 'eula url');

  assert.elementText($support, /Need Help\?.+/, 'support link label');
  assert.elementText($support.find('a'), 'Contact Support', 'support link label');
  assert.equal($support.find('a').attr('href'), 'https://www.twitch.tv/support', 'support url');
});

test('renders without optional info', function (assert) {
  this.product = {
    title: 'Gaem',
    developer_name: 'Yandere',
    publisher_name: 'Gaben',
    website_url: 'https://www.twitch.tv'
  };
  this.render(hbs`{{directory/game-details/game-information product=product}}`);

  let $details = this.$('.specification__list .js-game-details-detail');

  let $title = $details.eq(0);
  let $dev = $details.eq(1);
  let $pub = $details.eq(2);
  let $website = $details.eq(3);

  assert.elementCount($details, 4, '4 details');
  assert.elementText($title, /Title\:.+/, 'title label');
  assert.elementText($dev, /Developer\:.+/, 'developer label');
  assert.elementText($pub, /Publisher\:.+/, 'publisher label');
  assert.elementText($website, /More Info\:.+/, 'website link label');
});
