import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import wait from 'ember-test-helpers/wait';
import {
    loadGameDetail,
    loadOffer
} from 'web-client/tests/integration/components/directory/game-details/game-detail-helper';
import moment from 'moment';
import { assign } from 'ember-platform';
import {
  LAUNCHER,
  LAUNCHER_INFO,
  SUPPORT
} from 'web-client/utilities/urls/fuel';

const IMG_ESRB = 'https://images.tv/esrb';
const IMG_PLATFORM = 'https://images.tv/platform';
const IMG_REFERRAL_LOGO = 'https://images.tv/referral-logo';
const BROADCASTER_NAME = 'saobuks';

const GAME_OWNED = {
  product: {
    title: 'Owned game',
    game_id: 'owned-game-id',
    maturity_ratings: {
      esrb: {
        icon_url: IMG_ESRB
      }
    },
    supported_platforms: [{
      icon_url: IMG_PLATFORM
    }]
  },
  userEntitlement: {
    entitled: true
  }
};
const OFFER_VALID = {
  applicableGame: GAME_OWNED.product.title,
  contentDeliveryMethod: "DIRECT_ENTITLEMENT"
};

moduleForComponent('directory/game-details/get-game-card', 'Integration | Component | directory/game details/get game card', {
  beforeEach() {
    this.store = this.owner.lookup('service:store');
    this.loadGameDetail = loadGameDetail;
    this.loadOffer = loadOffer;
  }
});

test('it renders', function (assert) {
  assert.expect(8);

  this.loadGameDetail(GAME_OWNED);
  this.loadOffer(OFFER_VALID);

  this.render(hbs`
    {{directory/game-details/get-game-card
      gameDetail=gameDetail
      offer=offer}}`);

  return wait().then(() => {
    let $columns = this.$('.js-game-details-get-game > .flex__item');
    let $offer = $columns.eq(0);
    let $esrb = $columns.eq(1);
    let $platform = $columns.eq(2);
    let $launcherInfo = $columns.eq(3);
    let $launcherExe = $columns.eq(4);

    assert.equal($columns.length, 5, '5 columns total (offer, esrb, platform, launcher, rhs');
    assert.elementCount($offer.find('.js-game-details-get-game-offer'), 1, 'get-game-card/offer component is rendered');
    assert.equal($esrb.attr('src'), IMG_ESRB, 'esrb image');
    assert.equal($platform.attr('src'), IMG_PLATFORM, 'platform image');

    assert.elementText($launcherInfo, 'Play on Twitch', 'launcher info text');
    assert.equal($launcherInfo.find('a').attr('href'), LAUNCHER_INFO, 'launcher info URL');

    assert.elementText($launcherExe, 'Download the Twitch App', 'launcher exe text');
    assert.equal($launcherExe.find('a').attr('href'), LAUNCHER, 'launcher exe URL');
  });
});

test('renders unavailable game w/ a referral', function (assert) {
  assert.expect(6);

  let game = assign({}, GAME_OWNED);
  game.product.release_end_date = moment().subtract(1, 'days');
  game.userEntitlement.entitled = false;

  this.loadGameDetail(game);
  this.set('broadcasterLogo', IMG_REFERRAL_LOGO);
  this.set('broadcasterName', BROADCASTER_NAME);

  this.render(hbs`
    {{directory/game-details/get-game-card
      gameDetail=gameDetail
      broadcasterLogo=broadcasterLogo
      broadcasterName=broadcasterName}}`);

  return wait().then(() => {
    let $columns = this.$('.js-game-details-get-game > .flex__item');
    let $offer = $columns.eq(0);
    let $esrb = $columns.eq(1);
    let $referral = $columns.eq(2);

    assert.equal($columns.length, 3, '3 columns total (offer, esrb, referral');
    assert.elementCount($offer.find('.js-game-details-get-game-offer'), 1, 'get-game-card/offer component is rendered');
    assert.equal($esrb.attr('src'), IMG_ESRB, 'esrb image');

    assert.elementText($referral, `This purchase may support ${this.broadcasterName}`, 'referring broadcaster desc');
    assert.equal($referral.find('img').attr('src'), this.broadcasterLogo, 'referring broadcaster logo');
    assert.equal($referral.find('a').attr('href'), SUPPORT, 'help doc URL');
  });
});
