import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import wait from 'ember-test-helpers/wait';

moduleForComponent('directory/game-details/get-game-card/offer/dropdown', 'Integration | Component | directory/game details/get game card/offer/dropdown');

test('it renders', function (assert) {
  assert.expect(6);

  this.showBalloonFlag = false;
  this.render(hbs`
    {{#directory/game-details/get-game-card/offer/dropdown showBalloonFlag=showBalloonFlag}}
      balloon content
    {{/directory/game-details/get-game-card/offer/dropdown}}
  `);

  assert.elementText(this.$('button span'), 'Get it Now', 'button text');
  assert.elementText(this.$('.balloon'), 'balloon content', 'balloon content');
  assert.ok(this.$('.balloon').hasClass('hide'), 'balloon has class .hide (is hidden)');
  assert.notOk(this.$('.balloon').hasClass('show'), 'balloon doesnt have class .show (is hidden)');

  this.set('showBalloonFlag', true);
  return wait().then(() => {
    assert.notOk(this.$('.balloon').hasClass('hide'), 'balloon doesnt have class .hide (is shown)');
    assert.ok(this.$('.balloon').hasClass('show'), 'balloon has class .show (is shown)');
  });
});

test('clicking', function (assert) {
  assert.expect(3);

  this.render(hbs`
    {{#directory/game-details/get-game-card/offer/dropdown}}
      balloon content
    {{/directory/game-details/get-game-card/offer/dropdown}}
  `);

  assert.ok(this.$('.balloon').hasClass('hide'), 'ballloon is hidden at the start');

  this.$('button').click();
  return wait().then(() => {
    assert.ok(this.$('.balloon').hasClass('show'), 'clicking button shows balloon');

    this.$('button').click();
    return wait();
  }).then(() => {
    assert.ok(this.$('.balloon').hasClass('hide'), 'ballloon is hidden after clicking button again');

    this.$('button').click();
    return wait();
  });
});
