import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import sinon from 'sinon';
import Service from 'ember-service';
import RSVP from 'rsvp';
import wait from 'ember-test-helpers/wait';

moduleForComponent('directory/game-details/videos', 'Integration | Component | directory/game details/videos', {
  beforeEach() {
    this.owner.register('service:embeds', Service.extend({
      getEmbed() {
        return RSVP.resolve({});
      }
    }));
  }
});

test('renders multiple videos in a carousel', function (assert) {
  assert.expect(4);

  let flexsliderStub = sinon.stub($, 'flexslider');

  this.videos = [
    { video_id: '123' },
    { video_id: '456' },
    { video_id: '789' }
  ];
  this.render(hbs`{{directory/game-details/videos videos=videos}}`);

  return wait().then(() => {
    assert.elementText(this.$('.game-details__section-title'), 'Trailers', 'section title');
    assert.elementCount(this.$('.game-details__carousel--videos'), 1, 'videos carousel');
    assert.elementCount(this.$('.game-details__video'), 3, '3 videos rendered');
    assert.ok(flexsliderStub.called, 'flexslider was created for the carousel');

    flexsliderStub.restore();
  });
});

test('render single video', function (assert) {
  assert.expect(4);

  let flexsliderStub = sinon.stub($, 'flexslider');

  this.videos = [
    { video_id: '123' }
  ];
  this.render(hbs`{{directory/game-details/videos videos=videos}}`);

  return wait().then(() => {
    assert.elementText(this.$('.game-details__section-title'), 'Trailers', 'section title');
    assert.elementCount(this.$('.game-details__carousel--videos'), 0, 'no carousel');
    assert.elementCount(this.$('.game-details__video'), 1, '1 video rendered');
    assert.notOk(flexsliderStub.called, 'flexslider was created for the carousel');

    flexsliderStub.restore();
  });
});
