import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import Service from 'ember-service';
import RSVP from 'rsvp';
import wait from 'ember-test-helpers/wait';

moduleForComponent('directory/game-details/videos/embed', 'Integration | Component | directory/game details/videos/embed');

test('embeds svc is called with videoId', function (assert) {
  assert.expect(1);

  let videoId = '123';
  let videoUrl = `https://www.twitch.tv/videos/${videoId}`;

  this.owner.register('service:embeds', Service.extend({
    getEmbed(url) {
      assert.equal(url, videoUrl, 'correct videoUrl');
      return RSVP.resolve({});
    }
  }));

  // rendering the component should do the assert on `embeds.getEmbed`
  this.videoId = videoId;
  this.render(hbs`{{directory/game-details/videos/embed videoId=videoId}}`);

  return wait();
});

// TODO need better way to test that {{twitch-feed/embeds/video}} is rendered
