import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import { test } from 'ember-qunit';
import Service from 'ember-service';
import hbs from 'htmlbars-inline-precompile';
import FakeGoogleTag from 'web-client/tests/helpers/fake-googletag';

moduleForComponent('display-ad', 'Integration | Component | display ad');

test('it calls googletag.createSlot and googletag.destroySlot', function(assert) {
  assert.expect(5);
  let fakeSlot = {};

  let FakeGoogleTag2 = Service.extend({
    dfpAdUnitPathFor(name) {
      assert.equal(name, 'homepage');
      return `${name}-ad-unit-path`;
    },

    createSlot(options) {
      assert.equal(options.adUnitPath, 'homepage-ad-unit-path');
      assert.deepEqual(options.size, [1, 1], 'slotDimensions correctly passed in as "size" parameter');
      assert.equal(options.div, 'test-ad');
      return fakeSlot;
    },

    destroySlot(slot) {
      assert.equal(slot, fakeSlot, 'tears down the ad slot correctly');
    }
  });

  this.owner.register('service:googletag', FakeGoogleTag2);
  this.set('slotDimensions', [1, 1]);
  this.render(hbs`
    {{display-ad
      slotId="test-ad"
      slotName="myAdSlot"
      slotDimensions=slotDimensions}}`);
});

test('it renders the correct id and name', function(assert) {
  assert.expect(2);

  this.owner.register('service:googletag', FakeGoogleTag);
  this.set('slotDimensions', [1, 1]);
  this.render(hbs`
    {{display-ad
      slotId="my-ad-slot"
      slotName="myAdSlot"
      slotDimensions=slotDimensions}}`);

  let slot = this.$('#my-ad-slot');
  assert.equal(slot.length, 1, 'renders an ad slot with id #my-ad-slot');
  assert.equal(slot[0].getAttribute('name'), 'myAdSlot', 'slot has correct name attribute');
});
