/* globals window */
import { moduleForComponent, test } from 'ember-qunit';
import hbs from 'htmlbars-inline-precompile';
import wait from 'ember-test-helpers/wait';
import sinon from 'sinon';

moduleForComponent('extension-panel', 'Integration | Component | extension panel', {
  integration: true
});

function setExtension(self) {
  // GRAB the url of the testing rig. The extension iframe
  // has to be set to the same domain
  self.location = window.location.origin;

  let installedExtension = {
    extension: {
      viewerUrl: `${self.location}/not_a_real_path`,
      name: 'test extension'
    }
  };

  self.set('installedExtension', installedExtension);
  self.set('refreshPanelLayout', () => {});
}

test('it renders iframe and communicate with it', function(assert) {
  // CREATE a script to run in the iframe's document
  let done = assert.async();
  assert.expect(1);

  setExtension(this);

  // RENDER with the magic allow-same-origin policy set so that
  // the test can reach into the iframe and set a script.
  // Without that, a cross domain error would happen.
  this.render(hbs`{{extension-panel installedExtension=installedExtension testAllowSameOrigin=true refreshPanelLayout=(action refreshPanelLayout)}}`);
  this.$('iframe').ready(() => {
    let iframe = this.$('iframe').get(0);

    // WRITE a script into the iframe that will postMessage to the extension-panel
    let iframeObj = iframe.contentWindow || iframe.contentDocument.document || iframe.contentDocument;
    iframeObj.document.open();
    let scriptBlock = `
      <script type="text/javascript">
        window.parent.postMessage({action:'twitch-ext-loaded'},'${this.location}');
      </script>
    `;
    iframeObj.document.write(scriptBlock);
    iframeObj.document.close();

    return wait().then(() => {
      // GET a handle to the component and check that it got a message
      let componentId = iframe.parentNode.parentNode.id;
      let component = this.container.lookup('-view-registry:main')[componentId];
      let count = component.get('messageReceiveCount');
      assert.equal(count, 1, 'Message should be received from child iframe');
      done();
    });
  });
});

test('it renders iframe without allow-same-origin', function(assert) {
  // CREATE a script to run in the iframe's document
  assert.expect(1);

  setExtension(this);

  // RENDER with the magic allow-same-origin policy set so that
  // the test can reach into the iframe and set a script.
  // Without that, a cross domain error would happen.
  this.render(hbs`{{extension-panel installedExtension=installedExtension refreshPanelLayout=(action refreshPanelLayout)}}`);
  let attrs = this.$('iframe').attr('sandbox');
  assert.equal(attrs.indexOf('allow-same-origin'), -1, 'allow-same-origin should not be present on iframe by default');
});

test('it binds pubsub', function(assert) {
  assert.expect(1);

  setExtension(this);

  let pubsub = {
    on: sinon.spy(),
    off: sinon.spy()
  };
  this.set('pubsub', pubsub);
  this.render(hbs`{{extension-panel pubsub=pubsub installedExtension=installedExtension refreshPanelLayout=(action refreshPanelLayout)}}`);
  assert.ok(pubsub.on.calledOnce, 'binds pubsub');
});
