import moduleForComponent from 'web-client/tests/helpers/module-for-component';
import ChannelPage from '../../../pages/channel-feed';
import { test } from 'ember-qunit';
import RSVP from 'rsvp';
import EmberObject from 'ember-object';
import hbs from 'htmlbars-inline-precompile';
import { AuthenticatedSession } from 'web-client/tests/helpers/mock-session-service';
import { assign } from 'ember-platform';
import { JTV_USER_PICTURES_404_USER_150X150_URL } from 'web-client/utilities/urls/static-cdn';

const TOKEN = 'foobar';
const OauthSession = AuthenticatedSession.extend({
  userData: assign({chat_oauth_token: TOKEN}, AuthenticatedSession.prototype.userData),
  getOAuthToken() {
    return RSVP.resolve(TOKEN);
  }
});
const userDisplayName = 'yougert2k';
let channelName = 'twitch';
let page;

moduleForComponent('twitch-feed/comment', 'Integration | Component | twitch-feed/comment', {
  integration: true,

  beforeEach() {
    this.inject.service('store');
    page = ChannelPage.create({ name: channelName });
    let store = this.get('store');
    let [ user, post, comment ] = store.push({
      data: [
        {
          id: 'u1',
          type: 'feed-user',
          attributes: {
            login: 'twitch',
            displayName: userDisplayName,
            profileImage: JTV_USER_PICTURES_404_USER_150X150_URL
          }
        },
        {
          id: 'p1',
          type: 'post',
          attributes: {
            body: 'Hello World'
          },
          relationships: {
            user: { data: { type: 'feed-user', id: 'u1' } }
          }
        },
        {
          id: 'c1',
          type: 'comment',
          attributes: {
            body: 'Best comment ever',
            reactions: []
          },
          relationships: {
            user: { data: { id: 'u1', login: 'u1', type: 'feed-user' } },
            post: { data: { id: 'p1', type: 'post'} }
          }
        }
      ]
    });

    comment.get('reactions').pushObject(EmberObject.create({
      emoteId: 'endorse',
      emoteName: 'endorse',
      count: 0,
      userIds: []
    }));
    this.register('service:session', OauthSession);
    this.inject.service('feeds');
    this.set('feeds.meAsFeedUser', user);
    this.setProperties({ post, comment, user });
  }
});

test('user displayName and logo render properly', function (assert) {
  assert.expect(2);
  this.render(hbs`{{twitch-feed/comment comment=comment}}`);
  let profileImageSrc = this.$('.activity-comment img').attr('src');
  let renderedDisplayName = this.$('.activity-comment__meta a strong').text();
  assert.equal(profileImageSrc, JTV_USER_PICTURES_404_USER_150X150_URL, 'The user profile image renders');
  assert.equal(renderedDisplayName, userDisplayName, 'The correct display name renders');
});

test('can like a comment', function (assert) {
  assert.expect(4);
  let initCommentCount = 0;
  let reaction = this.get('comment.reactions')[0];
  reaction.set('count', initCommentCount);
  this.render(hbs`{{twitch-feed/comment comment=comment}}`);

  let commentReaction = this.$(page.commentReaction);
  assert.ok(commentReaction[0], 'Comment reaction renders');
  assert.equal(initCommentCount, parseInt(commentReaction.text().trim()), 'The correct count renders');
  commentReaction.click();

  assert.ok(commentReaction.hasClass('activity-comment__reaction--selected'), 'Comment reaction UI updated properly');
  assert.notEqual(initCommentCount, commentReaction.text().trim(), 'Reaction count increased by 1');
});

test('can unlike a comment', function (assert) {
  assert.expect(2);
  let initCommentCount = 1;
  let reaction = this.get('comment.reactions')[0];
  reaction.set('count', initCommentCount);
  reaction.set('userIds', [this.get('user.id')]);
  this.render(hbs`{{twitch-feed/comment comment=comment}}`);

  let commentReaction = this.$(page.commentReaction);
  assert.equal(initCommentCount, parseInt(commentReaction.text().trim()), 'The correct count renders');
  commentReaction.click();

  assert.notEqual(initCommentCount, commentReaction.text().trim(), 'Reaction count decreased by 1');
});
